/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import static com.google.common.base.Preconditions.checkArgument;
import static org.apache.commons.io.FileUtils.toFile;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

/**
 * Handles a reference to the exploded application from file system.
 *
 * @since 4.0
 */
public class FileSystemApplicationDeployer extends AbstractApplicationDeployer {

  public FileSystemApplicationDeployer(URL applicationUrl, RuntimeToolingService runtimeToolingService) {
    super(applicationUrl, runtimeToolingService);
  }

  @Override
  protected String doInternalInit(URL applicationUrlContent, RuntimeToolingService runtimeToolingService) {
    if (LOGGER.isDebugEnabled()) {
      LOGGER.debug("Deploying application from URL: {}", applicationUrlContent);
    }

    File appLocation = toFile(applicationUrlContent);
    checkArgument(appLocation != null && appLocation.exists(), "applicationUrl: " + applicationUrlContent + " is invalid");

    String applicationId;
    if (appLocation.isDirectory()) {
      applicationId = runtimeToolingService.deployApplication(appLocation);
    } else if (appLocation.isFile()) {
      try {
        applicationId = runtimeToolingService.deployApplication(new FileInputStream(appLocation));
      } catch (IOException e) {
        throw new ToolingException("Couldn't create inputStream for zip file from application URL: " + applicationUrlContent);
      }
    } else {
      throw new IllegalArgumentException("Couldn't handle URL for deploying application: " + applicationUrlContent);
    }
    return applicationId;
  }

}
