/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import static java.util.Objects.requireNonNull;
import org.mule.tooling.agent.RuntimeToolingService;

import java.net.URL;

/**
 * Creates a {@link ApplicationDeployer}.
 *
 * @since 4.0
 */
public final class RemoteApplicationContextFactory {

  /**
   * @param applicationUrlContent {@link URL} for the application content. Non null.
   * @param runtimeToolingService {@link RuntimeToolingService} to be used when context is deployed and disposed. Non null.
   * @return {@link ApplicationDeployer} for doing an operation against a Mule Runtime.
   */
  public static ApplicationDeployer createRemoteApplicationContext(URL applicationUrlContent,
                                                                   RuntimeToolingService runtimeToolingService) {
    requireNonNull(applicationUrlContent, "applicationUrlContent cannot be null");
    requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");

    if (applicationUrlContent.getProtocol().equals("file")) {
      return new FileSystemApplicationDeployer(applicationUrlContent, runtimeToolingService);
    } else {
      return new InputStreamApplicationDeployer(applicationUrlContent, runtimeToolingService);
    }
  }

}
