/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal.utils;

import org.mule.tooling.client.api.exception.ToolingException;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;

import java.util.concurrent.ExecutionException;

/**
 * Utility class for Tooling client services
 */
public final class ServiceUtils {

  private ServiceUtils() {}

  public static <T> T executeHandlingException(ResourceSupplier<T> supplier) {
    try {
      return supplier.getResource();
    } catch (ExecutionException e) {
      if (e.getCause() instanceof ToolingException) {
        throw (ToolingException) e.getCause();
      } else {
        throw new ToolingException(e.getCause());
      }
    } catch (UncheckedExecutionException e) {
      Throwables.propagateIfPossible(e.getCause(), ToolingException.class);
      throw new ToolingException(e);
    }
  }

  @FunctionalInterface
  public interface ResourceSupplier<T> {

    T getResource() throws ExecutionException;
  }

}
