/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.datasense.api.DataSenseComponentInfo;
import org.mule.datasense.api.DataSenseElementInfo;
import org.mule.datasense.api.DataSenseInfo;
import org.mule.datasense.api.notifications.DataSenseNotification;
import org.mule.datasense.api.notifications.DataSenseNotificationType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.tooling.client.api.datasense.ComponentIdentifier;
import org.mule.tooling.client.api.location.ComponentType;
import org.mule.tooling.client.api.location.Location;
import org.mule.tooling.client.api.location.LocationPart;
import org.mule.tooling.client.api.location.TypedComponentIdentifier;
import org.mule.tooling.client.api.metadata.FailureCode;
import org.mule.tooling.client.api.metadata.MetadataComponent;
import org.mule.tooling.client.internal.ExtensionModelPartsFactory;
import org.mule.tooling.client.internal.MetadataPartsFactory;

public class DataSensePartsFactory {
    private static ComponentType componentTypeToDTO(TypedComponentIdentifier.ComponentType componentType) {
        if (componentType == TypedComponentIdentifier.ComponentType.FLOW) {
            return ComponentType.flowComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.ERROR_HANDLER) {
            return ComponentType.errorHandlingComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.ON_ERROR) {
            return ComponentType.onErrorComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.OPERATION) {
            return ComponentType.operationComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.ROUTER) {
            return ComponentType.routerComponentType((String)componentType.name());
        }
        if (componentType == TypedComponentIdentifier.ComponentType.SOURCE) {
            return ComponentType.sourceComponentType((String)componentType.name());
        }
        return new ComponentType(componentType.name());
    }

    private static TypedComponentIdentifier toTypedComponentIdentifierDTO(org.mule.runtime.api.component.TypedComponentIdentifier typedComponentIdentifier) {
        if (typedComponentIdentifier == null) {
            return null;
        }
        org.mule.runtime.api.component.ComponentIdentifier componentIdentifier = typedComponentIdentifier.getIdentifier();
        TypedComponentIdentifier.ComponentType componentType = typedComponentIdentifier.getType();
        ComponentIdentifier componentIdentifierDTO = new ComponentIdentifier(componentIdentifier.getName(), componentIdentifier.getNamespace());
        ComponentType componentTypeDTO = new ComponentType(componentType.name());
        return new TypedComponentIdentifier(componentIdentifierDTO, componentTypeDTO);
    }

    private static LocationPart toLocationPartDTO(org.mule.runtime.api.component.location.LocationPart locationPart) {
        return new LocationPart(locationPart.getPartPath(), (String)locationPart.getFileName().orElse(null), (Integer)locationPart.getLineInFile().orElse(null), DataSensePartsFactory.toTypedComponentIdentifierDTO(locationPart.getPartIdentifier().orElse(null)));
    }

    private static List<LocationPart> toLocationPartsDTO(List<org.mule.runtime.api.component.location.LocationPart> locationParts) {
        return locationParts.stream().map(locationPart -> DataSensePartsFactory.toLocationPartDTO(locationPart)).collect(Collectors.toList());
    }

    private static org.mule.tooling.client.api.datasense.DataSenseNotificationType toDataSenseNotificationTypeDTO(DataSenseNotificationType type) {
        if (type == DataSenseNotificationType.ERROR) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.errorDataSenseNotificationType((String)type.name());
        }
        if (type == DataSenseNotificationType.FATAL_ERROR) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.fatalErrorDataSenseNotificationType((String)type.name());
        }
        if (type == DataSenseNotificationType.INFO) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.infoDataSenseNotificationType((String)type.name());
        }
        if (type == DataSenseNotificationType.WARNING) {
            return org.mule.tooling.client.api.datasense.DataSenseNotificationType.warningDataSenseNotificationType((String)type.name());
        }
        return new org.mule.tooling.client.api.datasense.DataSenseNotificationType(type.name());
    }

    private static org.mule.tooling.client.api.datasense.DataSenseNotification toDataSenseNotificationDTO(DataSenseNotification notification) {
        MetadataComponent component = notification.getMetadataComponent().isPresent() ? MetadataPartsFactory.toMetadataComponentDTO((org.mule.runtime.api.metadata.resolving.MetadataComponent)notification.getMetadataComponent().get()) : null;
        I18nMessage reason = notification.getReason().orElse(null);
        org.mule.tooling.client.api.datasense.I18nMessage reasonDTO = notification.getReason().isPresent() ? new org.mule.tooling.client.api.datasense.I18nMessage(reason.getMessage(), reason.getCode(), reason.getArgs()) : null;
        FailureCode failureCode = notification.getFailureCode().isPresent() ? new FailureCode(((org.mule.runtime.api.metadata.resolving.FailureCode)notification.getFailureCode().get()).getName()) : null;
        org.mule.tooling.client.api.location.ComponentLocation componentLocationDTO = null;
        if (notification.getComponentLocation().isPresent()) {
            ComponentLocation componentLocation = (ComponentLocation)notification.getComponentLocation().get();
            componentLocationDTO = new org.mule.tooling.client.api.location.ComponentLocation(componentLocation.getLocation(), (String)componentLocation.getFileName().orElse(null), (Integer)componentLocation.getLineInFile().orElse(null), DataSensePartsFactory.toTypedComponentIdentifierDTO(componentLocation.getComponentIdentifier()), DataSensePartsFactory.toLocationPartsDTO(componentLocation.getParts()));
        }
        return new org.mule.tooling.client.api.datasense.DataSenseNotification(DataSensePartsFactory.toDataSenseNotificationTypeDTO(notification.getNotificationType()), component, (String)notification.getFailingElement().orElse(null), failureCode, new org.mule.tooling.client.api.datasense.I18nMessage(notification.getMessage().getMessage(), notification.getMessage().getCode(), notification.getMessage().getArgs()), reasonDTO, componentLocationDTO);
    }

    private static List<org.mule.tooling.client.api.datasense.DataSenseNotification> toDataSenseMNotificationsDTO(List<DataSenseNotification> notifications) {
        return notifications.stream().map(dataSenseNotification -> DataSensePartsFactory.toDataSenseNotificationDTO(dataSenseNotification)).collect(Collectors.toList());
    }

    private static org.mule.tooling.client.api.datasense.DataSenseElementInfo toDataSenseElementInfoDTO(DataSenseElementInfo dataSenseElementInfo) {
        return org.mule.tooling.client.api.datasense.DataSenseElementInfo.newBuilder().withLocation(ExtensionModelPartsFactory.toLocationDTO(dataSenseElementInfo.getLocation())).withExpected((MetadataType)dataSenseElementInfo.getExpected().orElse(null)).withExpectedOutput((MetadataType)dataSenseElementInfo.getExpectedOutput().orElse(null)).withActualOutput((MetadataType)dataSenseElementInfo.getActualOutput().orElse(null)).withInput((MetadataType)dataSenseElementInfo.getInput().orElse(null)).withOutput((MetadataType)dataSenseElementInfo.getOutput().orElse(null)).withIncoming((MetadataType)dataSenseElementInfo.getIncoming().orElse(null)).withResult((MetadataType)dataSenseElementInfo.getResult().orElse(null)).withMessages(dataSenseElementInfo.getMessages()).withExpectedInput((MetadataType)dataSenseElementInfo.getExpectedInput().orElse(null)).withActualInput((MetadataType)dataSenseElementInfo.getActualInput().orElse(null)).build();
    }

    private static Map<Location, org.mule.tooling.client.api.datasense.DataSenseElementInfo> toMapDataSenseElementInfoDTO(Map<org.mule.runtime.api.component.location.Location, DataSenseElementInfo> map) {
        if (map == null) {
            return null;
        }
        HashMap<Location, org.mule.tooling.client.api.datasense.DataSenseElementInfo> dtoMap = new HashMap<Location, org.mule.tooling.client.api.datasense.DataSenseElementInfo>();
        for (org.mule.runtime.api.component.location.Location location : map.keySet()) {
            dtoMap.put(ExtensionModelPartsFactory.toLocationDTO(location), DataSensePartsFactory.toDataSenseElementInfoDTO(map.get(location)));
        }
        return dtoMap;
    }

    public static Optional<org.mule.tooling.client.api.datasense.DataSenseInfo> toDataSenseInfoDTO(Optional<DataSenseInfo> dataSenseInfoOptional) {
        if (!dataSenseInfoOptional.isPresent()) {
            return Optional.empty();
        }
        DataSenseInfo dataSenseInfo = dataSenseInfoOptional.get();
        return Optional.of(org.mule.tooling.client.api.datasense.DataSenseInfo.newBuilder().withLocation(ExtensionModelPartsFactory.toLocationDTO(dataSenseInfo.getLocation())).withActualInput((MetadataType)dataSenseInfo.getActualInput().orElse(null)).withActualOutput((MetadataType)dataSenseInfo.getActualOutput().orElse(null)).withExpected((MetadataType)dataSenseInfo.getExpected().orElse(null)).withExpectedInput((MetadataType)dataSenseInfo.getExpectedInput().orElse(null)).withExpectedOutput((MetadataType)dataSenseInfo.getExpectedOutput().orElse(null)).withIncoming((MetadataType)dataSenseInfo.getIncoming().orElse(null)).withInput((MetadataType)dataSenseInfo.getInput().orElse(null)).withOutput((MetadataType)dataSenseInfo.getOutput().orElse(null)).withResult((MetadataType)dataSenseInfo.getResult().orElse(null)).withOperationModel(ExtensionModelPartsFactory.toOperationModelDTO(dataSenseInfo.getOperationModel().orElse(null))).withSourceModel(ExtensionModelPartsFactory.toSourceModelDTO(dataSenseInfo.getSourceModel().orElse(null))).withMessages(dataSenseInfo.getMessages()).withComponentInfoByComponentPath(DataSensePartsFactory.toMapDataSenseElementInfoDTO(dataSenseInfo.getComponentInfoByComponentPath().orElse(null))).withNotifications(DataSensePartsFactory.toDataSenseMNotificationsDTO(dataSenseInfo.getDataSenseNotifications())).build());
    }

    public static Optional<org.mule.tooling.client.api.datasense.DataSenseComponentInfo> toDataSenseComponentInfoDTO(Optional<DataSenseComponentInfo> dataSenseComponentInfoOptional) {
        if (!dataSenseComponentInfoOptional.isPresent()) {
            return Optional.empty();
        }
        DataSenseComponentInfo dataSenseComponentInfo = dataSenseComponentInfoOptional.get();
        return Optional.of(new org.mule.tooling.client.api.datasense.DataSenseComponentInfo(ExtensionModelPartsFactory.toOperationModelDTO(dataSenseComponentInfo.getOperationModel().orElse(null)), ExtensionModelPartsFactory.toSourceModelDTO(dataSenseComponentInfo.getSourceModel().orElse(null)), dataSenseComponentInfo.getMessages(), DataSensePartsFactory.toDataSenseMNotificationsDTO(dataSenseComponentInfo.getDataSenseNotifications())));
    }
}

