/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.deployment.model.internal.tooling.ToolingPluginClassLoaderBuilder;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.api.persistence.ExtensionModelJsonSerializer;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.ExtensionModelDiscoverer;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleExtensionModelLoaderManager;
import org.mule.runtime.module.extension.internal.capability.xml.schema.DefaultExtensionSchemaGenerator;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExtensionModelService
implements InternalExtensionModelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExtensionModelService.class);
    private ExtensionModelDiscoverer extensionModelDiscoverer = new ExtensionModelDiscoverer();
    private MavenClient mavenClient;
    private MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;
    private ExtensionSchemaGenerator schemaGenerator = new DefaultExtensionSchemaGenerator();

    public DefaultExtensionModelService(MavenClient mavenClient, MuleArtifactResourcesRegistry muleArtifactResourcesRegistry) {
        Objects.requireNonNull(mavenClient, "mavenClient cannot be null");
        Objects.requireNonNull(muleArtifactResourcesRegistry, "muleArtifactResourcesRegistry cannot be null");
        this.mavenClient = mavenClient;
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
    }

    @Override
    public List<ExtensionModel> loadRuntimeExtensionModels() {
        return new ArrayList<ExtensionModel>(this.extensionModelDiscoverer.discoverRuntimeExtensionModels());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LoadedExtensionInformation> resolveExtensionModel(ArtifactPluginDescriptor artifactPluginDescriptor) throws IOException, MuleException {
        ToolingPluginClassLoaderBuilder builder = new ToolingPluginClassLoaderBuilder(this.muleArtifactResourcesRegistry.newTemporaryArtifactClassLoaderFactory(), this.muleArtifactResourcesRegistry.getPluginDependenciesResolver(), artifactPluginDescriptor, this.muleArtifactResourcesRegistry.getRegionPluginClassLoadersFactory());
        builder.setParentClassLoader(this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader());
        ToolingArtifactClassLoader toolingArtifactClassLoader = builder.build();
        try {
            MuleExtensionModelLoaderManager extensionModelLoaderRepository = new MuleExtensionModelLoaderManager(this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader());
            extensionModelLoaderRepository.start();
            Optional<LoadedExtensionInformation> optional = this.getLoadedExtensionInformation(artifactPluginDescriptor, toolingArtifactClassLoader, extensionModelLoaderRepository);
            return optional;
        }
        finally {
            toolingArtifactClassLoader.dispose();
        }
    }

    private Optional<LoadedExtensionInformation> getLoadedExtensionInformation(ArtifactPluginDescriptor pluginDescriptor, ToolingArtifactClassLoader toolingArtifactCL, MuleExtensionModelLoaderManager loaderRepository) {
        Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions = this.discoverPluginsExtensionModel(toolingArtifactCL, loaderRepository).stream().map(pair -> (Pair)ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), () -> {
            ExtensionModelJsonSerializer extensionModelJsonSerializer = new ExtensionModelJsonSerializer();
            return new Pair(pair.getFirst(), (Object)extensionModelJsonSerializer.deserialize(extensionModelJsonSerializer.serialize((ExtensionModel)pair.getSecond())));
        })).collect(Collectors.toSet());
        Optional<ExtensionModel> foundExtension = this.getExtensionModel(pluginDescriptor, descriptorsWithExtensions);
        if (foundExtension.isPresent()) {
            LazyValue<String> lazySchema = this.getSchema(descriptorsWithExtensions, foundExtension.get());
            return Optional.of(new LoadedExtensionInformation(foundExtension.get(), lazySchema, pluginDescriptor.getMinMuleVersion().toString()));
        }
        return Optional.empty();
    }

    private LazyValue<String> getSchema(Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions, ExtensionModel foundExtension) {
        Set extensions = descriptorsWithExtensions.stream().map(Pair::getSecond).collect(Collectors.toSet());
        return new LazyValue(() -> this.schemaGenerator.generate(foundExtension, DslResolvingContext.getDefault((Set)extensions)));
    }

    private Optional<ExtensionModel> getExtensionModel(ArtifactPluginDescriptor descriptor, Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions) {
        if (descriptorsWithExtensions.isEmpty()) {
            return Optional.empty();
        }
        return descriptorsWithExtensions.stream().filter(e -> ((ArtifactPluginDescriptor)e.getFirst()).equals(descriptor)).map(Pair::getSecond).findFirst();
    }

    private Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> discoverPluginsExtensionModel(ToolingArtifactClassLoader toolingArtifactCL, MuleExtensionModelLoaderManager extensionModelLoaderRepository) {
        List artifacts = toolingArtifactCL.getArtifactPluginClassLoaders().stream().map(a -> new Pair((Object)a.getArtifactDescriptor(), a)).collect(Collectors.toList());
        return this.extensionModelDiscoverer.discoverPluginsExtensionModels((ExtensionModelLoaderRepository)extensionModelLoaderRepository, artifacts);
    }

    @Override
    public Optional<LoadedExtensionInformation> loadExtensionData(BundleDescriptor pluginDescriptor) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading extension model for {}", (Object)pluginDescriptor);
        }
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder();
        builder.setGroupId(pluginDescriptor.getGroupId()).setArtifactId(pluginDescriptor.getArtifactId()).setType(pluginDescriptor.getType()).setVersion(pluginDescriptor.getVersion()).setClassifier((String)pluginDescriptor.getClassifier().orElse(null)).build();
        ArtifactPluginDescriptor artifactPluginDescriptor = this.readBundleDescriptor(new File(this.mavenClient.resolveBundleDescriptor(builder.build()).getBundleUri()));
        try {
            return this.resolveExtensionModel(artifactPluginDescriptor);
        }
        catch (Exception e) {
            throw new ToolingException((Throwable)e);
        }
    }

    @Override
    public ArtifactPluginDescriptor readBundleDescriptor(File pluginFile) {
        try {
            ArtifactPluginDescriptor artifactPluginDescriptor = this.muleArtifactResourcesRegistry.getArtifactPluginDescriptorLoader().load(pluginFile);
            return artifactPluginDescriptor;
        }
        catch (Exception e) {
            throw new ToolingException("Error while loading ExtensionModel for plugin: " + pluginFile.getAbsolutePath(), (Throwable)e);
        }
    }
}

