/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.maven.client.api.MavenClient;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.SpiRuntimeToolingServiceProvider;
import org.mule.tooling.client.internal.ToolingArtifactContext;
import org.mule.tooling.client.internal.application.ApplicationService;

public class DefaultToolingArtifactContext
implements ToolingArtifactContext {
    private SpiRuntimeToolingServiceProvider runtimeToolingServiceProvider = new SpiRuntimeToolingServiceProvider();
    private volatile transient boolean runtimeToolingServiceInitialized;
    private RuntimeToolingService runtimeToolingService;
    private Optional<AgentConfiguration> agentConfigurationOptional;
    private ApplicationCache applicationCache;
    private MavenClient mavenClient;
    private MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider;
    private ApplicationService applicationService;

    public void setAgentConfiguration(Optional<AgentConfiguration> agentConfigurationOptional) {
        this.agentConfigurationOptional = agentConfigurationOptional;
    }

    @Override
    public Optional<AgentConfiguration> getAgentConfiguration() {
        return this.agentConfigurationOptional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeToolingService getRuntimeToolingService() {
        if (!this.runtimeToolingServiceInitialized) {
            DefaultToolingArtifactContext defaultToolingArtifactContext = this;
            synchronized (defaultToolingArtifactContext) {
                if (!this.runtimeToolingServiceInitialized) {
                    this.runtimeToolingService = this.runtimeToolingServiceProvider.lookUpRuntimeToolingService();
                    if (!this.agentConfigurationOptional.isPresent()) {
                        throw new MissingToolingConfigurationException("Tooling Client has to be configure with a configuration to access REST Tooling API in order to resolve operations");
                    }
                    AgentConfiguration agentConfiguration = this.agentConfigurationOptional.get();
                    this.runtimeToolingService.setToolingApiUrl(agentConfiguration.getToolingApiUrl(), agentConfiguration.getDefaultConnectTimeout(), agentConfiguration.getDefaultReadTimeout(), agentConfiguration.getSSLContext());
                    this.runtimeToolingServiceInitialized = true;
                }
            }
        }
        return this.runtimeToolingService;
    }

    @Override
    public ApplicationCache getApplicationCache() {
        return this.applicationCache;
    }

    public void setApplicationCache(ApplicationCache applicationCache) {
        this.applicationCache = applicationCache;
    }

    public void setMavenClient(MavenClient mavenClient) {
        this.mavenClient = mavenClient;
    }

    @Override
    public MavenClient getMavenClient() {
        return this.mavenClient;
    }

    public void setMuleRuntimeExtensionModelProvider(MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider) {
        this.muleRuntimeExtensionModelProvider = muleRuntimeExtensionModelProvider;
    }

    @Override
    public MuleRuntimeExtensionModelProvider getMuleRuntimeExtensionModelProvider() {
        return this.muleRuntimeExtensionModelProvider;
    }

    public void setApplicationService(ApplicationService applicationService) {
        this.applicationService = applicationService;
    }

    @Override
    public ApplicationService getApplicationService() {
        return this.applicationService;
    }
}

