/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Optional;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.internal.ApplicationCache;
import org.mule.tooling.client.internal.CachedExtensionModelService;
import org.mule.tooling.client.internal.DefaultExtensionModelService;
import org.mule.tooling.client.internal.DefaultToolingRuntimeClient;
import org.mule.tooling.client.internal.ExtensionModelServiceCache;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.application.DefaultApplicationService;

public class DefaultToolingRuntimeClientBuilder
implements ToolingRuntimeClient.Builder {
    private MavenClient mavenClient;
    private ModuleRepository moduleRepository;
    private ArtifactClassLoader containerClassLoaderFactory;
    private ExtensionModelServiceCache extensionModelServiceCache;
    private ApplicationCache applicationCache;
    private AgentConfiguration agentConfiguration;

    public DefaultToolingRuntimeClientBuilder(MavenClient bootstrapMavenClient, ModuleRepository moduleRepository, ArtifactClassLoader containerClassLoaderFactory, ExtensionModelServiceCache extensionModelServiceCache, ApplicationCache applicationCache) {
        this.mavenClient = bootstrapMavenClient;
        this.moduleRepository = moduleRepository;
        this.containerClassLoaderFactory = containerClassLoaderFactory;
        this.extensionModelServiceCache = extensionModelServiceCache;
        this.applicationCache = applicationCache;
    }

    public ToolingRuntimeClient.Builder withRemoteAgentConfiguration(AgentConfiguration agentConfiguration) {
        this.agentConfiguration = agentConfiguration;
        return this;
    }

    public ToolingRuntimeClient.Builder withMavenConfiguration(MavenConfiguration mavenConfiguration) {
        this.mavenClient = MavenClientProvider.discoverProvider((ClassLoader)DefaultToolingRuntimeClientBuilder.class.getClassLoader()).createMavenClient(mavenConfiguration);
        return this;
    }

    public ToolingRuntimeClient build() {
        MuleArtifactResourcesRegistry muleArtifactResourcesRegistry = new MuleArtifactResourcesRegistry(this.mavenClient, this.moduleRepository, this.containerClassLoaderFactory);
        DefaultExtensionModelService extensionModelService = new DefaultExtensionModelService(this.mavenClient, muleArtifactResourcesRegistry);
        CachedExtensionModelService muleRuntimeExtensionModelProvider = new CachedExtensionModelService(this.extensionModelServiceCache, extensionModelService);
        DefaultApplicationService applicationService = new DefaultApplicationService(muleArtifactResourcesRegistry);
        return new DefaultToolingRuntimeClient(this.mavenClient, Optional.ofNullable(this.agentConfiguration), muleRuntimeExtensionModelProvider, applicationService, this.applicationCache);
    }
}

