/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataRequest;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalMetadataProvider
implements MetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RemoteApplicationInvoker remoteApplicationInvoker;

    public InternalMetadataProvider(RemoteApplicationInvoker remoteApplicationInvoker) {
        Preconditions.checkNotNull((Object)remoteApplicationInvoker, (Object)"remoteApplicationInvoker cannot be null");
        this.remoteApplicationInvoker = remoteApplicationInvoker;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting metadata keys for: {} on application: {}", (Object)metadataKeysRequest, (Object)this.remoteApplicationInvoker);
        }
        try {
            return this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.getMetadataKeys(applicationId, metadataKeysRequest.getLocation().toString(), metadataKeysRequest.getRequestTimeout()));
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onKeys()});
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(MetadataRequest metadataRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting operation metadata for: {} on application: {}", (Object)metadataRequest, (Object)this.remoteApplicationInvoker);
        }
        try {
            return this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.getOperationMetadata(applicationId, metadataRequest.getLocation().toString(), metadataRequest.getRequestTimeout()));
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(MetadataRequest metadataRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting source metadata for: {} on application: {}", (Object)metadataRequest, (Object)this.remoteApplicationInvoker);
        }
        try {
            return this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.getSourceMetadata(applicationId, metadataRequest.getLocation().toString(), metadataRequest.getRequestTimeout()));
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
        }
    }
}

