/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.application.MuleApplicationClassLoaderFactory;
import org.mule.runtime.deployment.model.internal.nativelib.ArtifactCopyNativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinder;
import org.mule.runtime.deployment.model.internal.nativelib.NativeLibraryFinderFactory;
import org.mule.runtime.deployment.model.internal.tooling.ToolingApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;
import org.mule.tooling.client.internal.application.ApplicationService;

public class DefaultApplicationService
implements ApplicationService {
    private MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;

    public DefaultApplicationService(MuleArtifactResourcesRegistry muleArtifactResourcesRegistry) {
        Objects.requireNonNull(muleArtifactResourcesRegistry, "muleArtifactResourcesRegistry cannot be null");
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
    }

    @Override
    public ToolingArtifactClassLoader createApplicationClassLoader(String applicationName, File applicationLocation, File workingDirectory) throws IOException {
        ToolingApplicationClassLoaderBuilder builder = new ToolingApplicationClassLoaderBuilder((DeployableArtifactClassLoaderFactory)new MuleApplicationClassLoaderFactory((NativeLibraryFinderFactory)new ToolingNativeLibraryFinderFactory(workingDirectory)), this.muleArtifactResourcesRegistry.getRegionPluginClassLoadersFactory());
        builder.setParentClassLoader(this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader());
        ApplicationDescriptor artifactDescriptor = (ApplicationDescriptor)this.muleArtifactResourcesRegistry.getApplicationDescriptorFactory().create(applicationLocation, Optional.empty());
        builder.setArtifactDescriptor((ArtifactDescriptor)artifactDescriptor);
        List resolvedArtifactPluginDescriptors = this.muleArtifactResourcesRegistry.getPluginDependenciesResolver().resolve((List)ImmutableList.builder().addAll((Iterable)artifactDescriptor.getPlugins()).build());
        resolvedArtifactPluginDescriptors.stream().forEach(xva$0 -> builder.addArtifactPluginDescriptors(new ArtifactPluginDescriptor[]{xva$0}));
        return builder.build();
    }

    private class ToolingNativeLibraryFinderFactory
    implements NativeLibraryFinderFactory {
        private File workingDirectory;

        public ToolingNativeLibraryFinderFactory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public NativeLibraryFinder create(String name, URL[] urls) {
            return new ArtifactCopyNativeLibraryFinder(new File(new File(this.workingDirectory, name), "temp"), urls);
        }
    }
}

