/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dsl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.maven.client.api.MavenClient;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverFactory;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolverService;
import org.mule.tooling.client.api.artifact.dsl.request.DslSyntaxResolverFactoryRequest;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.dsl.DslSyntaxServiceCache;
import org.mule.tooling.client.internal.dsl.ServiceDelegatingDslSyntaxResolver;
import org.mule.tooling.client.internal.utils.ExtensionModelUtils;

public class DefaultDslSyntaxResolverService
implements DslSyntaxResolverService {
    private final DslSyntaxServiceCache dslSyntaxServiceCache;

    public DefaultDslSyntaxResolverService(MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider, MavenClient mavenClient) {
        this.dslSyntaxServiceCache = new DslSyntaxServiceCache(mavenClient, muleRuntimeExtensionModelProvider);
    }

    public DslSyntaxResolverFactory getDslSyntaxResolverFactory(DslSyntaxResolverFactoryRequest request) {
        Preconditions.checkArgument((request != null ? 1 : 0) != 0, (String)"The resolution request cannot be null");
        final List pluginArtifactDescriptors = request.getPluginArtifactDescriptors();
        Preconditions.checkArgument((pluginArtifactDescriptors != null ? 1 : 0) != 0, (String)"pluginArtifactDescriptors cannot be null");
        Preconditions.checkArgument((!pluginArtifactDescriptors.isEmpty() ? 1 : 0) != 0, (String)"At least one artifact plugin is required");
        final DefaultDslSyntaxResolverService delegate = this;
        return new DslSyntaxResolverFactory(){

            public DslSyntaxResolver createDslResolver(org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel) {
                return new ServiceDelegatingDslSyntaxResolver(delegate, toolingModel, pluginArtifactDescriptors);
            }

            public void dispose() {
                DefaultDslSyntaxResolverService.this.dslSyntaxServiceCache.invalidate(pluginArtifactDescriptors);
            }
        };
    }

    public void dispose() {
        this.dslSyntaxServiceCache.invalidate();
    }

    public void invalidate(List<ArtifactDescriptor> pluginArtifactDescriptors, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel) {
        this.dslSyntaxServiceCache.invalidate(pluginArtifactDescriptors, toolingModel);
    }

    public DslElementSyntax resolve(SourceModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(OperationModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConstructModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConnectionProviderModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConfigurationModel component, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        return this.doResolve(extension -> ExtensionModelUtils.find(extension, component), toolingModel, pluginArtifactDescriptors);
    }

    Optional<DslElementSyntax> resolve(MetadataType type, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        DslResolvingContext context = this.dslSyntaxServiceCache.getContext(pluginArtifactDescriptors);
        return this.dslSyntaxServiceCache.getResolver(this.findExtension(toolingModel, context), context).resolve(type).map(this::toDslDto);
    }

    private DslElementSyntax doResolve(Function<ExtensionModel, NamedObject> componentProvider, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        DslResolvingContext context = this.dslSyntaxServiceCache.getContext(pluginArtifactDescriptors);
        ExtensionModel extension = this.findExtension(toolingModel, context);
        return this.toDslDto(this.dslSyntaxServiceCache.getResolver(extension, context).resolve(componentProvider.apply(extension)));
    }

    private ExtensionModel findExtension(org.mule.tooling.client.api.extension.model.ExtensionModel toolingExtensionModel, DslResolvingContext resolvingContext) {
        return (ExtensionModel)resolvingContext.getExtension(toolingExtensionModel.getName()).orElseThrow(() -> new IllegalArgumentException(String.format("Extension with name [%s] not found in the current context. Available extensions are %s", resolvingContext.getExtensions().stream().map(e -> e.getName()).collect(Collectors.toList()))));
    }

    private DslElementSyntax toDslDto(org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax origin) {
        return new DslElementSyntax(origin.getAttributeName(), origin.getElementName(), origin.getPrefix(), origin.getNamespace(), origin.isWrapped(), origin.supportsAttributeDeclaration(), origin.supportsChildDeclaration(), origin.supportsTopLevelDeclaration(), origin.requiresConfig(), origin.getGenerics().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toDslDto((org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax)e.getValue()))), origin.getContainedElementsByName().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.toDslDto((org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax)e.getValue()))));
    }
}

