/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dsl;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.artifact.dsl.DslElementSyntax;
import org.mule.tooling.client.api.artifact.dsl.DslSyntaxResolver;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.extension.model.ExtensionModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.construct.ConstructModel;
import org.mule.tooling.client.api.extension.model.operation.OperationModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.dsl.DefaultDslSyntaxResolverService;

class ServiceDelegatingDslSyntaxResolver
implements DslSyntaxResolver {
    private final DefaultDslSyntaxResolverService delegate;
    private final ExtensionModel toolingModel;
    private final List<ArtifactDescriptor> pluginArtifactDescriptors;

    ServiceDelegatingDslSyntaxResolver(DefaultDslSyntaxResolverService service, ExtensionModel toolingModel, List<ArtifactDescriptor> pluginArtifactDescriptors) {
        this.delegate = service;
        this.toolingModel = toolingModel;
        this.pluginArtifactDescriptors = pluginArtifactDescriptors;
    }

    public DslElementSyntax resolve(ConfigurationModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConnectionProviderModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(ConstructModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(OperationModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public DslElementSyntax resolve(SourceModel component) {
        return this.delegate.resolve(component, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public Optional<DslElementSyntax> resolve(MetadataType type) {
        return this.delegate.resolve(type, this.toolingModel, this.pluginArtifactDescriptors);
    }

    public void dispose() {
        this.delegate.invalidate(this.pluginArtifactDescriptors, this.toolingModel);
    }
}

