/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.internal.application.ApplicationDeployerFactory;
import org.mule.tooling.client.internal.application.Deployable;
import org.mule.tooling.client.internal.application.ImmutableApplicationDeployable;
import org.mule.tooling.client.internal.application.InputStreamApplicationDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(Application.class);
    private final MavenClient mavenClient;
    private final ExtensionModelService extensionModelService;
    private StampedLock lock = new StampedLock();
    private Supplier<URL> applicationUrlContentSupplier;
    private Supplier<RuntimeToolingService> runtimeToolingServiceSupplier;
    protected String applicationId;

    public Application(Supplier<URL> applicationUrlContentSupplier, Supplier<RuntimeToolingService> runtimeToolingServiceSupplier, MavenClient mavenClient, ExtensionModelService extensionModelService) {
        Objects.requireNonNull(applicationUrlContentSupplier, "applicationUrlContentSupplier cannot be null");
        Objects.requireNonNull(runtimeToolingServiceSupplier, "runtimeToolingServiceSupplier cannot be null");
        this.applicationUrlContentSupplier = applicationUrlContentSupplier;
        this.runtimeToolingServiceSupplier = runtimeToolingServiceSupplier;
        this.mavenClient = mavenClient;
        this.extensionModelService = extensionModelService;
    }

    public List<ExtensionModel> getPluginDependencies() {
        List<BundleDependency> bundleDependencies = this.resolveDependencies();
        List<ExtensionModel> extensionModels = bundleDependencies.stream().filter(dependency -> "mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null))).map(dependency -> this.extensionModelService.loadExtensionModel(new File(dependency.getBundleUri())).orElse(null)).filter(extensionModel -> extensionModel != null).collect(Collectors.toList());
        return extensionModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BundleDependency> resolveDependencies() {
        List list;
        File applicationFile = null;
        boolean deleteApplicationFile = false;
        File workDir = Files.createTempDir();
        try {
            block19: {
                URL applicationUrl = this.applicationUrlContentSupplier.get();
                try {
                    if (applicationUrl.getProtocol().equals("file")) {
                        applicationFile = FileUtils.toFile((URL)applicationUrl);
                        break block19;
                    }
                    byte[] fileContent = InputStreamApplicationDeployer.readContentFromUrl(applicationUrl);
                    File tempApplicationFile = org.mule.runtime.core.api.util.FileUtils.createTempFile((String)"application", (String)"");
                    try (FileOutputStream outputStream = new FileOutputStream(applicationFile);){
                        IOUtils.write((byte[])fileContent, (OutputStream)outputStream);
                    }
                    applicationFile = tempApplicationFile;
                    deleteApplicationFile = true;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            list = this.mavenClient.resolveArtifactDependencies(applicationFile, false, Optional.of(this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation()), Optional.of(workDir));
        }
        catch (Throwable throwable) {
            FileUtils.deleteQuietly((File)workDir);
            if (deleteApplicationFile) {
                FileUtils.deleteQuietly(applicationFile);
            }
            throw throwable;
        }
        FileUtils.deleteQuietly((File)workDir);
        if (deleteApplicationFile) {
            FileUtils.deleteQuietly((File)applicationFile);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        block5: {
            long stamp = this.lock.writeLock();
            try {
                if (this.applicationId == null) break block5;
                try {
                    this.runtimeToolingServiceSupplier.get().disposeApplication(this.applicationId);
                }
                catch (ServiceUnavailableException e) {
                    LOGGER.warn("Runtime Tooling Service is unavailable");
                }
                this.applicationId = null;
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deployable deploy() {
        long stamp = this.lock.readLock();
        try {
            if (this.applicationId == null) {
                long writeStamp = this.lock.tryConvertToWriteLock(stamp);
                if (writeStamp == 0L) {
                    this.lock.unlockRead(stamp);
                    stamp = this.lock.writeLock();
                } else {
                    stamp = writeStamp;
                }
                if (this.applicationId == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("It is required to deploy the application: {} in order to resolveArtifact the operation requested", (Object)this.applicationUrlContentSupplier.get());
                    }
                    this.applicationId = ApplicationDeployerFactory.createApplicationDeployer(this.applicationUrlContentSupplier.get(), this.runtimeToolingServiceSupplier.get()).deploy();
                }
            }
            ImmutableApplicationDeployable immutableApplicationDeployable = new ImmutableApplicationDeployable(this.applicationId, this.applicationUrlContentSupplier, this.runtimeToolingServiceSupplier);
            return immutableApplicationDeployable;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }
}

