/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.artifact;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.type.TypeCatalog;

public class ExpandedDslResolvingContext
implements DslResolvingContext {
    private final TypeCatalog typeCatalog;
    private final DslResolvingContext delegate;
    private final Map<String, ExtensionModel> extensions;

    public ExpandedDslResolvingContext(DslResolvingContext delegate, Set<ExtensionModel> addedExtensions) {
        this.delegate = delegate;
        this.extensions = addedExtensions.stream().filter(e -> !delegate.getExtension(e.getName()).isPresent()).collect(Collectors.toMap(ExtensionModel::getName, e -> e, (u, v) -> v, LinkedHashMap::new));
        this.typeCatalog = new DelegatingTypeCatalog(delegate.getTypeCatalog(), (Set<ExtensionModel>)ImmutableSet.copyOf(this.extensions.values()));
    }

    public Optional<ExtensionModel> getExtension(String name) {
        return Optional.ofNullable(this.delegate.getExtension(name).orElseGet(() -> this.extensions.get(name)));
    }

    public Set<ExtensionModel> getExtensions() {
        return ImmutableSet.builder().addAll((Iterable)this.delegate.getExtensions()).addAll(this.extensions.values()).build();
    }

    public TypeCatalog getTypeCatalog() {
        return this.typeCatalog;
    }

    private static final class DelegatingTypeCatalog
    implements TypeCatalog {
        private final TypeCatalog originalCatalog;
        private final TypeCatalog extendingCatalog;

        public DelegatingTypeCatalog(TypeCatalog delegate, Set<ExtensionModel> addedExtensions) {
            this.originalCatalog = delegate;
            this.extendingCatalog = TypeCatalog.getDefault(addedExtensions);
        }

        public Optional<ObjectType> getType(String typeId) {
            Optional type = this.extendingCatalog.getType(typeId);
            return type.isPresent() ? type : this.originalCatalog.getType(typeId);
        }

        public Collection<ObjectType> getTypes() {
            return this.mergeAvoidingDuplicates((ImmutableCollection.Builder)ImmutableList.builder(), this.originalCatalog.getTypes(), this.extendingCatalog.getTypes());
        }

        public Set<ObjectType> getSubTypes(ObjectType type) {
            return (Set)this.mergeAvoidingDuplicates((ImmutableCollection.Builder)ImmutableSet.builder(), this.originalCatalog.getSubTypes(type), this.extendingCatalog.getSubTypes(type));
        }

        public Set<ObjectType> getSuperTypes(ObjectType type) {
            return (Set)this.mergeAvoidingDuplicates((ImmutableCollection.Builder)ImmutableSet.builder(), this.originalCatalog.getSuperTypes(type), this.extendingCatalog.getSuperTypes(type));
        }

        public Collection<ObjectType> getAllBaseTypes() {
            return this.mergeAvoidingDuplicates((ImmutableCollection.Builder)ImmutableList.builder(), this.originalCatalog.getAllBaseTypes(), this.extendingCatalog.getAllBaseTypes());
        }

        public Collection<ObjectType> getAllSubTypes() {
            return this.mergeAvoidingDuplicates((ImmutableCollection.Builder)ImmutableList.builder(), this.originalCatalog.getAllSubTypes(), this.extendingCatalog.getAllSubTypes());
        }

        public boolean containsBaseType(ObjectType type) {
            return this.extendingCatalog.containsBaseType(type) || this.originalCatalog.containsBaseType(type);
        }

        public Collection<ObjectType> getExtensionTypes(String extensionName) {
            return this.mergeAvoidingDuplicates((ImmutableCollection.Builder)ImmutableList.builder(), this.originalCatalog.getExtensionTypes(extensionName), this.extendingCatalog.getExtensionTypes(extensionName));
        }

        public Optional<String> getDeclaringExtension(String typeId) {
            Optional extension = this.extendingCatalog.getDeclaringExtension(typeId);
            return extension.isPresent() ? extension : this.originalCatalog.getDeclaringExtension(typeId);
        }

        private <T extends Collection> T mergeAvoidingDuplicates(ImmutableCollection.Builder builder, Collection first, Collection second) {
            builder.addAll((Iterable)first);
            second.stream().filter(o -> !first.contains(o)).forEach(arg_0 -> ((ImmutableCollection.Builder)builder).add(arg_0));
            return (T)builder.build();
        }
    }
}

