/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.maven.client.api.MavenClient;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.ToolingRuntimeClient;
import org.mule.tooling.client.api.artifact.ConnectivityTestingServiceBuilder;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.artifact.declaration.ArtifactSerializationService;
import org.mule.tooling.client.api.configuration.agent.AgentConfiguration;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.tryit.TryItService;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.mule.tooling.client.internal.DefaultToolingArtifact;
import org.mule.tooling.client.internal.DefaultTryItService;
import org.mule.tooling.client.internal.Initializable;
import org.mule.tooling.client.internal.TemporaryConnectivityTestingServiceBuilder;
import org.mule.tooling.client.internal.artifact.DefaultArtifactSerializationService;

class DefaultToolingRuntimeClient
implements ToolingRuntimeClient {
    private final MavenClient mavenClient;
    private final ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;
    private AgentConfiguration agentConfiguration;
    private Supplier<RuntimeToolingService> runtimeToolingServiceSupplier;
    private RuntimeToolingService runtimeToolingService;
    private ExtensionModelService extensionModelService;
    private ArtifactSerializationService artifactSerializationService;
    private TryItService tryItService;

    DefaultToolingRuntimeClient(Supplier<RuntimeToolingService> runtimeToolingServiceSupplier, MavenClient mavenClient, Optional<AgentConfiguration> agentConfiguration, ExtensionModelService extensionModelService, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        Preconditions.checkNotNull(runtimeToolingServiceSupplier, (Object)"runtimeToolingServiceSupplier cannot be null");
        Preconditions.checkNotNull((Object)mavenClient, (Object)"aetherDependencyResolver cannot be null");
        Preconditions.checkNotNull(agentConfiguration, (Object)"agentConfiguration cannot be null");
        this.mavenClient = mavenClient;
        this.runtimeToolingServiceSupplier = runtimeToolingServiceSupplier;
        this.agentConfiguration = agentConfiguration.orElse(null);
        this.componentBuildingDefinitionLoader = componentBuildingDefinitionLoader;
        this.extensionModelService = extensionModelService;
        this.artifactSerializationService = new DefaultArtifactSerializationService(extensionModelService.loadMuleCoreExtensionModel(), extensionModelService, mavenClient);
        this.tryItService = new DefaultTryItService(this::configurableRuntimeToolingServiceSupplier);
        this.initServices();
    }

    private void initServices() {
        this.initIfNeeded(this.extensionModelService);
        this.initIfNeeded(this.artifactSerializationService);
        this.initIfNeeded(this.tryItService);
    }

    private void initIfNeeded(Object service) {
        if (service instanceof Initializable) {
            ((Initializable)service).init();
        }
    }

    public ToolingArtifact newToolingArtifact(Supplier<URL> applicationUrlSupplier) {
        return new DefaultToolingArtifact(applicationUrlSupplier, this::configurableRuntimeToolingServiceSupplier, this.mavenClient, this.extensionModelService, this.componentBuildingDefinitionLoader);
    }

    public ToolingArtifact fetchToolingArtifact(String applicationId, Supplier<URL> applicationUrlSupplier) {
        return new DefaultToolingArtifact(applicationId, applicationUrlSupplier, this::configurableRuntimeToolingServiceSupplier, this.mavenClient, this.extensionModelService, this.componentBuildingDefinitionLoader);
    }

    public TryItService tryItService() {
        return this.tryItService;
    }

    public ConnectivityTestingServiceBuilder newConnectivityTestingService() {
        return new TemporaryConnectivityTestingServiceBuilder(this.configurableRuntimeToolingServiceSupplier());
    }

    private RuntimeToolingService configurableRuntimeToolingServiceSupplier() {
        if (this.runtimeToolingService != null) {
            return this.runtimeToolingService;
        }
        if (this.agentConfiguration == null) {
            throw new MissingToolingConfigurationException("Tooling Client has to be configure with a configuration to access REST Tooling API in order to resolve operations");
        }
        this.runtimeToolingService = this.runtimeToolingServiceSupplier.get();
        this.runtimeToolingService.setToolingApiUrl((URL)this.agentConfiguration.getToolingApiURLSupplier().get(), this.agentConfiguration.getDefaultConnectTimeout(), this.agentConfiguration.getDefaultReadTimeout(), this.agentConfiguration.getSSLContext());
        return this.runtimeToolingService;
    }

    public ExtensionModelService extensionModelService() {
        return this.extensionModelService;
    }

    public ArtifactSerializationService artifactSerializationService() {
        return this.artifactSerializationService;
    }
}

