/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.tryIt.AgentTrackingNotificationResponse;
import org.mule.tooling.client.api.tryit.MessageHistory;
import org.mule.tooling.client.api.tryit.NotificationAction;
import org.mule.tooling.client.api.tryit.TryItService;
import org.mule.tooling.client.api.types.Transaction;
import org.mule.tooling.client.api.types.TransactionStackEntry;
import org.mule.tooling.client.api.types.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTryItService
implements TryItService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FIRST_MESSAGE_PROCESSOR_INDEX = "/0";
    private static final String MESSAGE_PRE_INVOKE_ACTION = "message processor pre invoke";
    private static final String MESSAGE_POST_INVOKE_ACTION = "message processor post invoke";
    private static final Map<String, NotificationAction> actionMapping = ImmutableMap.builder().put((Object)"message processor pre invoke", (Object)NotificationAction.BEFORE).put((Object)"message processor post invoke", (Object)NotificationAction.AFTER).build();
    private Supplier<RuntimeToolingService> runtimeToolingServiceSupplier;

    protected DefaultTryItService(Supplier<RuntimeToolingService> runtimeToolingServiceSupplier) {
        Objects.requireNonNull(runtimeToolingServiceSupplier, "runtimeToolingServiceSupplier cannot be null");
        this.runtimeToolingServiceSupplier = runtimeToolingServiceSupplier;
    }

    public void enable(String applicationName) {
        this.runtimeToolingServiceSupplier.get().enableTryIt(applicationName);
    }

    public MessageHistory consume(String applicationName, int chunkSize) {
        List agentTrackingNotifications = this.runtimeToolingServiceSupplier.get().consumeTryItNotifications(applicationName, chunkSize);
        return this.convertToMessageHistory(agentTrackingNotifications);
    }

    private MessageHistory convertToMessageHistory(List<AgentTrackingNotificationResponse> agentTrackingNotifications) {
        MessageHistory messageHistory = new MessageHistory();
        ArrayList transactions = new ArrayList();
        messageHistory.setTransactions(transactions);
        Map<String, List<AgentTrackingNotificationResponse>> notificationsMap = this.splitAgentNotificationsAndSortByDate(agentTrackingNotifications);
        notificationsMap.keySet().stream().forEach(transactionId -> {
            List transactionNotifications = (List)notificationsMap.get(transactionId);
            Transaction transaction = new Transaction();
            transaction.setTransactionStatus(TransactionStatus.COMPLETE);
            transaction.setId(((AgentTrackingNotificationResponse)transactionNotifications.get(0)).getTransactionId());
            AgentTrackingNotificationResponse firstMessageProcessorInputNotification = (AgentTrackingNotificationResponse)transactionNotifications.get(0);
            if (firstMessageProcessorInputNotification.getComponentLocation().getLocation().endsWith(FIRST_MESSAGE_PROCESSOR_INDEX) && firstMessageProcessorInputNotification.getAction().equals(MESSAGE_PRE_INVOKE_ACTION)) {
                transaction.setMessage(firstMessageProcessorInputNotification.getEvent().getMessage());
                transaction.setTimestamp(firstMessageProcessorInputNotification.getTimestamp());
            }
            transaction.setTransactionStack(transactionNotifications.stream().filter(agentTrackingNotification -> agentTrackingNotification.getAction().equals(MESSAGE_POST_INVOKE_ACTION)).map(agentTrackingNotification -> {
                TransactionStackEntry transactionStackEntry = new TransactionStackEntry();
                transactionStackEntry.setTimestamp(agentTrackingNotification.getTimestamp());
                transactionStackEntry.setBranchId(agentTrackingNotification.getBranchId());
                transactionStackEntry.setParentBranchId(agentTrackingNotification.getParentBranchId());
                transactionStackEntry.setComponentLocation(agentTrackingNotification.getComponentLocation());
                transactionStackEntry.setEventModel(agentTrackingNotification.getEvent());
                return transactionStackEntry;
            }).collect(Collectors.toList()));
            transactions.add(transaction);
        });
        return messageHistory;
    }

    private Map<String, List<AgentTrackingNotificationResponse>> splitAgentNotificationsAndSortByDate(List<AgentTrackingNotificationResponse> agentTrackingNotifications) {
        this.logger.debug("Grouping notifications by transactionId");
        HashMap<String, List<AgentTrackingNotificationResponse>> notificationsMap = new HashMap<String, List<AgentTrackingNotificationResponse>>();
        agentTrackingNotifications.stream().forEach(agentTrackingNotification -> {
            this.logger.debug("Processing notification: {}", agentTrackingNotification);
            ArrayList<AgentTrackingNotificationResponse> notifications = (ArrayList<AgentTrackingNotificationResponse>)notificationsMap.get(agentTrackingNotification.getTransactionId());
            if (notifications == null) {
                notifications = new ArrayList<AgentTrackingNotificationResponse>();
                notificationsMap.put(agentTrackingNotification.getTransactionId(), notifications);
            }
            notifications.add((AgentTrackingNotificationResponse)agentTrackingNotification);
        });
        for (List transactinAgentNotifications : notificationsMap.values()) {
            Collections.sort(transactinAgentNotifications, Comparator.comparingLong(AgentTrackingNotificationResponse::getTimestamp));
        }
        return notificationsMap;
    }

    public void disable(String applicationName) {
        try {
            this.runtimeToolingServiceSupplier.get().disableTryIt(applicationName);
        }
        catch (Exception e) {
            this.logger.warn("Error while disabling application for try it", (Throwable)e);
        }
    }
}

