/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.application.ApplicationDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemApplicationDeployer
implements ApplicationDeployer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private URL applicationUrl;
    private RuntimeToolingService runtimeToolingService;

    public FileSystemApplicationDeployer(URL applicationUrl, RuntimeToolingService runtimeToolingService) {
        Objects.requireNonNull(applicationUrl, "applicationUrl cannot be null");
        Objects.requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");
        this.applicationUrl = applicationUrl;
        this.runtimeToolingService = runtimeToolingService;
    }

    @Override
    public String deploy() {
        String applicationId;
        File appLocation;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Deploying application from URL: {}", (Object)this.applicationUrl);
        }
        Preconditions.checkArgument(((appLocation = FileUtils.toFile((URL)this.applicationUrl)) != null && appLocation.exists() ? 1 : 0) != 0, (Object)("applicationUrl: " + this.applicationUrl + " is invalid"));
        if (appLocation.isDirectory()) {
            applicationId = this.runtimeToolingService.deployApplication(appLocation);
        } else if (appLocation.isFile()) {
            try {
                applicationId = this.runtimeToolingService.deployApplication((InputStream)new FileInputStream(appLocation));
            }
            catch (IOException e) {
                throw new ToolingException("Couldn't create inputStream for zip file from application URL: " + this.applicationUrl);
            }
        } else {
            throw new IllegalArgumentException("Couldn't handle URL for deploying application: " + this.applicationUrl);
        }
        return applicationId;
    }
}

