/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.mule.tooling.agent.RuntimeToolingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SpiRuntimeToolingServiceProvider
implements Supplier<RuntimeToolingService> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile transient boolean initialized;
    private RuntimeToolingService runtimeToolingService;

    SpiRuntimeToolingServiceProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeToolingService get() {
        if (!this.initialized) {
            SpiRuntimeToolingServiceProvider spiRuntimeToolingServiceProvider = this;
            synchronized (spiRuntimeToolingServiceProvider) {
                if (!this.initialized) {
                    this.runtimeToolingService = this.lookUpToolingService();
                    this.initialized = true;
                    return this.runtimeToolingService;
                }
            }
        }
        return this.runtimeToolingService;
    }

    private RuntimeToolingService lookUpToolingService() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using SPI mechanism to look for the implementation of {} to be used by the client", (Object)RuntimeToolingService.class.getName());
        }
        ServiceLoader<RuntimeToolingService> serviceLoader = ServiceLoader.load(RuntimeToolingService.class, this.getClass().getClassLoader());
        Preconditions.checkState((boolean)serviceLoader.iterator().hasNext(), (Object)("No service found for: '" + RuntimeToolingService.class.getName() + "'"));
        return serviceLoader.iterator().next();
    }
}

