/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.Objects;
import java.util.function.Supplier;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.TimeoutMethodUtils;
import org.mule.tooling.client.internal.application.Deployable;

public class DefaultConnectivityTestingService
implements ConnectivityTestingService {
    private Supplier<Deployable> deployableApplicationSupplier;

    public DefaultConnectivityTestingService(Supplier<Deployable> deployableApplicationSupplier) {
        Objects.requireNonNull(deployableApplicationSupplier, "deployableApplicationSupplier cannot be null");
        this.deployableApplicationSupplier = deployableApplicationSupplier;
    }

    public ConnectionValidationResult testConnection(ConnectivityTestingRequest connectivityTestingRequest) throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException, ConnectivityTestingObjectNotFoundException, ToolingException, ServiceUnavailableException {
        return TimeoutMethodUtils.withTimeout(connectivityTestingRequest.getRequestTimeout(), () -> {
            Deployable deployable = this.deployableApplicationSupplier.get();
            return deployable.getRuntimeToolingService().testConnection(deployable.getApplicationId(), connectivityTestingRequest.getComponentId());
        }, null);
    }
}

