/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.application.ApplicationDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamApplicationDeployer
implements ApplicationDeployer {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private URL applicationUrl;
    private RuntimeToolingService runtimeToolingService;

    public InputStreamApplicationDeployer(URL applicationUrl, RuntimeToolingService runtimeToolingService) {
        Objects.requireNonNull(applicationUrl, "applicationUrl cannot be null");
        Objects.requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");
        this.applicationUrl = applicationUrl;
        this.runtimeToolingService = runtimeToolingService;
    }

    @Override
    public String deploy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Deploying application from URL: {}", (Object)this.applicationUrl);
        }
        byte[] content = InputStreamApplicationDeployer.readContentFromUrl(this.applicationUrl);
        return this.runtimeToolingService.deployApplication((InputStream)new ByteArrayInputStream(content));
    }

    public static byte[] readContentFromUrl(URL applicationUrl) {
        byte[] content;
        BufferedInputStream inputStream = null;
        Closeable outputStream = null;
        try {
            URLConnection urlConnection = applicationUrl.openConnection();
            urlConnection.setConnectTimeout(5000);
            urlConnection.setReadTimeout(5000);
            inputStream = new BufferedInputStream(urlConnection.getInputStream());
            ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)bufferOutputStream);
            content = bufferOutputStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new ToolingException("Error while reading application content from URL: " + applicationUrl, (Throwable)e);
            }
            catch (Throwable throwable) {
                org.mule.runtime.core.api.util.IOUtils.closeQuietly(outputStream);
                org.mule.runtime.core.api.util.IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        org.mule.runtime.core.api.util.IOUtils.closeQuietly(outputStream);
        org.mule.runtime.core.api.util.IOUtils.closeQuietly((Closeable)inputStream);
        return content;
    }
}

