/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.tooling.agent.RuntimeToolingService;

import java.net.URL;

/**
 * Factory for {@link ApplicationDeployer}.
 *
 * @since 4.0
 */
public final class ApplicationDeployerFactory {

  private static final String FILE_URL_PROTOCOL = "file";

  private ApplicationDeployerFactory() {}

  /**
   * @return {@link ApplicationDeployer} that allows to deploy the application content.
   */
  public static ApplicationDeployer createApplicationDeployer(URL applicationUrl, RuntimeToolingService runtimeToolingService) {
    if (applicationUrl.getProtocol().equals(FILE_URL_PROTOCOL)) {
      return new FileSystemApplicationDeployer(applicationUrl, runtimeToolingService);
    } else {
      return new InputStreamApplicationDeployer(applicationUrl, runtimeToolingService);
    }
  }

}
