/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import org.mule.runtime.api.app.declaration.ArtifactDeclaration;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;

import com.mulesoft.agent.domain.tooling.BundleDescriptor;

import java.util.List;

/**
 * Dynamic implementation of a {@link ConnectivityTestingService} that defines
 * the list of {@link BundleDescriptor}'s for extensions to be used by the application
 * and the {@link ArtifactDeclaration declaration} for the application.
 *
 * @since 4.0
 */
public class TemporaryConnectivityTestingService implements ConnectivityTestingService {

  private RuntimeToolingService runtimeToolingService;
  private List<BundleDescriptor> dependencies;
  private ArtifactDeclaration artifactDeclaration;

  /**
   * Creates an instance of the service.
   *  @param runtimeToolingService {@link RuntimeToolingService} to resolve connectivity testing.
   * @param dependencies {@link List} of {@link BundleDescriptor} for dependencies of the application.
   * @param artifactDeclaration {@link ArtifactDeclaration} defines the application declaration in an object model.
   */
  public TemporaryConnectivityTestingService(RuntimeToolingService runtimeToolingService, List<BundleDescriptor> dependencies,
                                             ArtifactDeclaration artifactDeclaration) {
    this.runtimeToolingService = runtimeToolingService;
    this.dependencies = dependencies;
    this.artifactDeclaration = artifactDeclaration;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectionValidationResult testConnection(ConnectivityTestingRequest connectivityTestingRequest)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ServiceUnavailableException, ToolingException {
    return runtimeToolingService.testConnection(dependencies, artifactDeclaration,
                                                connectivityTestingRequest.getComponentId());
  }

}
