/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinitionProvider;
import org.mule.runtime.module.extension.internal.config.ExtensionBuildingDefinitionProvider;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;

public class CachedComponentBuildingDefinitionProviderLoader
implements ComponentBuildingDefinitionLoader {
    private Cache<ExtensionModelKey, List<ComponentBuildingDefinition>> cache = CacheBuilder.newBuilder().maximumSize((long)Integer.valueOf(System.getProperty("tooling.client.ComponentBuildingDefinitionProviderLoader.cache", "100")).intValue()).build();

    @Override
    public List<ComponentBuildingDefinition> loadComponentBuildingDefinitions(ComponentBuildingDefinitionProvider componentBuildingDefinitionProvider, Set<ExtensionModel> extensionModels) {
        if (!(componentBuildingDefinitionProvider instanceof ExtensionBuildingDefinitionProvider)) {
            componentBuildingDefinitionProvider.init();
            return componentBuildingDefinitionProvider.getComponentBuildingDefinitions();
        }
        try {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            HashMap splittedProviders = new HashMap();
            for (ExtensionModel extensionModel : extensionModels) {
                listBuilder.addAll((Iterable)this.cache.get((Object)new ExtensionModelKey(extensionModel.getName(), extensionModel.getVersion()), () -> {
                    if (splittedProviders.containsKey(extensionModel.getXmlDslModel().getPrefix())) {
                        return (List)splittedProviders.get(extensionModel.getXmlDslModel().getPrefix());
                    }
                    List<ComponentBuildingDefinition> componentBuildingDefinitions = this.retrieveComponentBuildingDefinitions(componentBuildingDefinitionProvider, extensionModels);
                    componentBuildingDefinitions.forEach(definition -> {
                        String definitionNamespace = definition.getComponentIdentifier().getNamespace();
                        ArrayList<ComponentBuildingDefinition> definitions = (ArrayList<ComponentBuildingDefinition>)splittedProviders.get(definitionNamespace);
                        if (definitions == null) {
                            definitions = new ArrayList<ComponentBuildingDefinition>();
                            splittedProviders.put(definitionNamespace, definitions);
                        }
                        definitions.add((ComponentBuildingDefinition)definition);
                    });
                    List extensionModelDefinitons = (List)splittedProviders.get(extensionModel.getXmlDslModel().getPrefix());
                    return extensionModelDefinitons != null ? extensionModelDefinitons : Collections.emptyList();
                }));
            }
            return listBuilder.build();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    private List<ComponentBuildingDefinition> retrieveComponentBuildingDefinitions(ComponentBuildingDefinitionProvider componentBuildingDefinitionProvider, Set<ExtensionModel> extensionModels) {
        if (componentBuildingDefinitionProvider instanceof ExtensionBuildingDefinitionProvider) {
            ((ExtensionBuildingDefinitionProvider)componentBuildingDefinitionProvider).setExtensionModels(extensionModels);
        }
        componentBuildingDefinitionProvider.init();
        return componentBuildingDefinitionProvider.getComponentBuildingDefinitions();
    }

    public static class ExtensionModelKey {
        private String name;
        private String version;

        public ExtensionModelKey(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtensionModelKey that = (ExtensionModelKey)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.version.equals(that.version);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }
    }
}

