/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import java.util.List;
import java.util.Map;
import org.mule.tooling.client.api.dataweave.DataWeaveModuleOption;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunnerProvider;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.pojo.JavaDataFormat;

public class DefaultDataWeaveService
implements DataWeaveService {
    private final DataWeaveRunnerProvider runnerProvider;
    private final ModulesAnalyzer modulesAnalyzer;

    public DefaultDataWeaveService(DataWeaveRunnerProvider runnerProvider, ModulesAnalyzer modulesAnalyzer) {
        this.runnerProvider = runnerProvider;
        this.modulesAnalyzer = modulesAnalyzer;
    }

    public DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters) {
        EventModel event = parameters.getEvent();
        if (event != null && this.anyInputIsJavaBased(event)) {
            throw new IllegalArgumentException("Java input not supported, serialize to DW script");
        }
        return this.getRunnerProvider().getRunner(parameters).execute(parameters);
    }

    private boolean anyInputIsJavaBased(EventModel event) {
        MessageModel message = event.getMessage();
        if (this.isJavaBased(message.getPayload()) || this.isJavaBased(message.getAttributes())) {
            return true;
        }
        Map variables = event.getVariables();
        return variables != null && variables.values().stream().anyMatch(this::isJavaBased);
    }

    private boolean isJavaBased(TypedValueModel model) {
        return model != null && JavaDataFormat.isJavaMimeType((String)model.getDataType().getMediaType());
    }

    public List<DataWeaveModuleOption> getReaderOptions(String contentType) {
        return this.getModulesAnalyzer().getOptions(contentType, DataFormat::readerOptions);
    }

    public List<DataWeaveModuleOption> getWriterOptions(String contentType) {
        return this.getModulesAnalyzer().getOptions(contentType, DataFormat::writerOptions);
    }

    public ModulesAnalyzer getModulesAnalyzer() {
        return this.modulesAnalyzer;
    }

    public DataWeaveRunnerProvider getRunnerProvider() {
        return this.runnerProvider;
    }
}

