/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.mule.datasense.api.DataSense;
import org.mule.datasense.api.DataSenseComponentInfo;
import org.mule.datasense.api.DataSenseInfo;
import org.mule.datasense.api.DataSenseResolutionScope;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.CachedDataSenseProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataCacheProvider;
import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.api.metadataprovider.DefaultDataSenseProvider;
import org.mule.datasense.api.metadataprovider.ExtensionsProvider;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.tooling.client.api.datasense.DataSenseRequest;
import org.mule.tooling.client.api.datasense.DataSenseResolveRequest;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.exception.MissingToolingConfigurationException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.internal.ApplicationModelFactory;
import org.mule.tooling.client.internal.ApplicationModelFactoryFromExpandedFolder;
import org.mule.tooling.client.internal.ApplicationModelFactoryFromUrl;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.TimeoutMethodUtils;
import org.mule.tooling.client.internal.ToolingDataSenseMetadataProvider;
import org.mule.tooling.client.internal.application.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataSenseService
implements DataSenseService {
    private static final String FILE_PROTOCOL = "file";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;
    private DataSense dataSense = new DefaultDataSense();
    private Supplier<URL> applicationUrlSupplier;
    private MetadataProvider metadataProvider;
    private MetadataService metadataService;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private ApplicationModelFactory applicationModelFactory;
    private ApplicationModel applicationModel;
    private ExtensionsProvider extensionsProviderSupplier;

    public DefaultDataSenseService(Supplier<URL> applicationUrlSupplier, MetadataProvider metadataProvider, MetadataService metadataService, final Application application, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        Preconditions.checkNotNull(applicationUrlSupplier, (Object)"applicationUrlSupplier cannot be null");
        Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        Preconditions.checkNotNull((Object)metadataService, (Object)"metadataService cannot be null");
        this.applicationUrlSupplier = applicationUrlSupplier;
        this.metadataProvider = metadataProvider;
        this.metadataService = metadataService;
        this.componentBuildingDefinitionLoader = componentBuildingDefinitionLoader;
        this.extensionsProviderSupplier = new ExtensionsProvider(){
            private Set<ExtensionModel> extensionModels;

            public Set<ExtensionModel> getExtensions() {
                if (this.extensionModels == null) {
                    this.extensionModels = ImmutableSet.builder().addAll(application.getPluginDependencies()).build();
                }
                return this.extensionModels;
            }
        };
    }

    public Optional<DataSenseInfo> resolveDataSense(DataSenseRequest dataSenseRequest) {
        this.buildApplicationModel();
        Location location = dataSenseRequest.getLocation();
        DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider = dataSenseRequest.getDataSenseMetadataCacheProvider();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving DataSense for component location: {} on application: {}", (Object)dataSenseRequest.getLocation(), (Object)this.applicationUrlSupplier.get());
        }
        return TimeoutMethodUtils.withTimeout(dataSenseRequest.getRequestTimeout(), () -> {
            try {
                DataSenseResolutionScope dataSenseResolutionScope;
                ApplicationModel applicationModel = this.getApplicationModel(this.extensionsProviderSupplier.getExtensions());
                DataSenseProvider dataSenseProvider = this.getDataSenseProvider(this.extensionsProviderSupplier, dataSenseMetadataCacheProvider, dataSenseRequest);
                DataSenseResolutionScope dataSenseResolutionScope2 = dataSenseResolutionScope = dataSenseRequest instanceof DataSenseResolveRequest ? ((DataSenseResolveRequest)dataSenseRequest).getDataSenseResolutionScope() : null;
                if (dataSenseResolutionScope == null) {
                    return this.dataSense.resolve(location, applicationModel, dataSenseProvider);
                }
                return this.dataSense.resolve(dataSenseResolutionScope, applicationModel, dataSenseProvider);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, MissingToolingConfigurationException.class);
                throw new ToolingException("Error while resolving DataSense for location: " + location + " on applicationUrl: " + this.applicationUrlSupplier.get(), (Throwable)e);
            }
        }, null);
    }

    private void buildApplicationModel() {
        if (this.isApplicationExploded()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Working with application expanded file path");
            }
            this.applicationModelFactory = new ApplicationModelFactoryFromExpandedFolder(this.componentBuildingDefinitionLoader);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Working with remote compressed application content");
            }
            this.applicationModelFactory = new ApplicationModelFactoryFromUrl(this.componentBuildingDefinitionLoader);
        }
    }

    public Optional<DataSenseComponentInfo> resolveComponentDataSense(DataSenseRequest dataSenseRequest) {
        this.buildApplicationModel();
        Location location = dataSenseRequest.getLocation();
        DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider = dataSenseRequest.getDataSenseMetadataCacheProvider();
        Preconditions.checkNotNull((Object)location, (Object)"location cannot be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resolving DataSense for location: {} on application: {}", (Object)dataSenseRequest.getLocation(), (Object)this.applicationUrlSupplier.get());
        }
        return TimeoutMethodUtils.withTimeout(dataSenseRequest.getRequestTimeout(), () -> {
            try {
                ApplicationModel applicationModel = this.getApplicationModel(this.extensionsProviderSupplier.getExtensions());
                DataSenseProvider dataSenseProvider = this.getDataSenseProvider(this.extensionsProviderSupplier, dataSenseMetadataCacheProvider, dataSenseRequest);
                return this.dataSense.resolveComponent(location, applicationModel, dataSenseProvider);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, MissingToolingConfigurationException.class);
                throw new ToolingException("Error while resolving DataSense for location: " + location + " on applicationUrl: " + this.applicationUrlSupplier.get(), (Throwable)e);
            }
        }, null);
    }

    private DataSenseProvider getDataSenseProvider(ExtensionsProvider extensionsProvider, DataSenseMetadataCacheProvider dataSenseMetadataCacheProvider, DataSenseRequest request) {
        DefaultDataSenseProvider dataSenseProvider = new DefaultDataSenseProvider(extensionsProvider, (DataSenseMetadataProvider)new ToolingDataSenseMetadataProvider(this.metadataProvider, this.metadataService, request.getMetadataTimeout()));
        if (dataSenseMetadataCacheProvider != null) {
            dataSenseProvider = new CachedDataSenseProvider(this.applicationModel, dataSenseMetadataCacheProvider, (DataSenseProvider)dataSenseProvider);
        }
        return dataSenseProvider;
    }

    private boolean isApplicationExploded() {
        return this.applicationUrlSupplier.get().getProtocol().equals(FILE_PROTOCOL) && FileUtils.toFile((URL)this.applicationUrlSupplier.get()).isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationModel getApplicationModel(Set<ExtensionModel> extensionModels) {
        this.readLock.lock();
        try {
            if (this.applicationModel != null) {
                ApplicationModel applicationModel = this.applicationModel;
                return applicationModel;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            if (this.applicationModel != null) {
                ApplicationModel applicationModel = this.applicationModel;
                return applicationModel;
            }
            ApplicationModel applicationModel = this.applicationModel = this.applicationModelFactory.createApplicationModel(this.applicationUrlSupplier.get(), extensionModels).orElseThrow(() -> new ToolingException("Couldn't create ApplicationModel for application: " + this.applicationUrlSupplier.get()));
            return applicationModel;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

