/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.net.URL;
import org.mule.maven.client.api.MavenClient;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.extension.ExtensionModelService;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.mule.tooling.client.internal.DefaultConnectivityTestingService;
import org.mule.tooling.client.internal.DefaultDataSenseService;
import org.mule.tooling.client.internal.DefaultMetadataService;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.application.FetchedApplication;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunnerProvider;
import org.mule.tooling.client.internal.dataweave.DefaultDataWeaveService;
import org.mule.tooling.client.internal.dataweave.LocalRunner;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.dataweave.RemoteRunner;

public class DefaultToolingArtifact
implements ToolingArtifact {
    private Application application;
    private ConnectivityTestingService connectivityTestingService;
    private MetadataService metadataService;
    private DataSenseService dataSenseService;
    private DataWeaveService dataWeaveService;

    public DefaultToolingArtifact(String applicationId, java.util.function.Supplier<URL> applicationUrlSupplier, java.util.function.Supplier<RuntimeToolingService> runtimeToolingServiceSupplier, MavenClient mavenClient, ExtensionModelService extensionModelService, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        Preconditions.checkNotNull(applicationUrlSupplier, (Object)"applicationUrlSupplier cannot be null");
        Preconditions.checkNotNull(runtimeToolingServiceSupplier, (Object)"runtimeToolingServiceSupplier cannot be null");
        applicationUrlSupplier = () -> ((Supplier)Suppliers.memoize(applicationUrlSupplier::get)).get();
        runtimeToolingServiceSupplier = () -> ((Supplier)Suppliers.memoize(runtimeToolingServiceSupplier::get)).get();
        this.application = applicationId != null ? new FetchedApplication(applicationId, applicationUrlSupplier, runtimeToolingServiceSupplier, mavenClient, extensionModelService) : new Application(applicationUrlSupplier, runtimeToolingServiceSupplier, mavenClient, extensionModelService);
        this.connectivityTestingService = new DefaultConnectivityTestingService(() -> this.application.deploy());
        DefaultMetadataService defaultMetadataService = new DefaultMetadataService(() -> this.application.deploy());
        this.metadataService = defaultMetadataService;
        this.dataSenseService = new DefaultDataSenseService(applicationUrlSupplier, defaultMetadataService, defaultMetadataService, this.application, componentBuildingDefinitionLoader);
        RemoteRunner remoteRunner = new RemoteRunner(() -> this.application.deploy());
        LocalRunner localRunner = new LocalRunner();
        this.dataWeaveService = new DefaultDataWeaveService(new DataWeaveRunnerProvider(localRunner, remoteRunner), new ModulesAnalyzer());
    }

    public DefaultToolingArtifact(java.util.function.Supplier<URL> applicationUrlSupplier, java.util.function.Supplier<RuntimeToolingService> runtimeToolingServiceSupplier, MavenClient mavenClient, ExtensionModelService extensionModelService, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        this(null, applicationUrlSupplier, runtimeToolingServiceSupplier, mavenClient, extensionModelService, componentBuildingDefinitionLoader);
    }

    public String getApplicationId() {
        return this.application.deploy().getApplicationId();
    }

    public ConnectivityTestingService connectivityTestingService() {
        return this.connectivityTestingService;
    }

    public MetadataService metadataService() {
        return this.metadataService;
    }

    public DataSenseService dataSenseService() {
        return this.dataSenseService;
    }

    public DataWeaveService dataweaveService() {
        return this.dataWeaveService;
    }

    public synchronized void dispose() {
        this.application.dispose();
    }
}

