/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dataweave;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewRequest;
import org.mule.tooling.client.api.dataweave.DataWeavePreviewResponse;
import org.mule.tooling.client.internal.dataweave.IDataWeaveRunner;
import org.mule.tooling.event.model.EventModel;
import org.mule.tooling.event.model.MessageModel;
import org.mule.tooling.event.model.TypedValueModel;
import org.mule.weave.v2.el.WeaveExpressionLanguage;

public class LocalRunner
implements IDataWeaveRunner {
    private static final String APPLICATION_JAVA = "application/java";
    private static final String DEFAULT_ATTRIBUTES_MEDIA_TYPE = "application/java";
    private static final String VARIABLES_ID = "variables";
    private static final String ATTRIBUTES_ID = "attributes";
    private static final String PAYLOAD_ID = "payload";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataWeavePreviewResponse execute(DataWeavePreviewRequest parameters) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            WeaveExpressionLanguage executor = new WeaveExpressionLanguage();
            TypedValue response = executor.evaluate(this.getScript(parameters), this.buildContextFromParameters(parameters));
            DataWeavePreviewResponse dataWeavePreviewResponse = DataWeavePreviewResponse.builder().result(this.getResult(response)).mediaType(this.getMediaType(response)).valid(Boolean.valueOf(true)).build();
            return dataWeavePreviewResponse;
        }
        catch (Exception e) {
            DataWeavePreviewResponse dataWeavePreviewResponse = DataWeavePreviewResponse.builder().errorMessage(e.getMessage()).build();
            return dataWeavePreviewResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    private String getMediaType(TypedValue evaluate) {
        DataType dataType = evaluate.getDataType();
        MediaType mediaType = dataType.getMediaType();
        return mediaType.withoutParameters().toString();
    }

    private String getResult(TypedValue result) {
        try {
            Object value = result.getValue();
            if (value instanceof CursorStreamProvider) {
                CursorStreamProvider streamProvider = (CursorStreamProvider)result.getValue();
                Charset encoding = result.getDataType().getMediaType().getCharset().orElseGet(Charset::defaultCharset);
                CursorStream cursorStream = (CursorStream)streamProvider.openCursor();
                String content = IOUtils.toString((InputStream)cursorStream, (Charset)encoding);
                streamProvider.close();
                return content;
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson(value);
        }
        catch (IOException e) {
            throw new RuntimeException("DataWeave :: Error consuming DataWeave result", e);
        }
    }

    private BindingContext buildContextFromParameters(DataWeavePreviewRequest parameters) throws IOException {
        BindingContext.Builder bindingBuilder = BindingContext.builder();
        EventModel event = this.getEvent(parameters);
        if (event != null) {
            this.manageVariables(bindingBuilder, event);
            this.manageMessage(bindingBuilder, event);
        }
        return bindingBuilder.build();
    }

    private void manageMessage(BindingContext.Builder bindingBuilder, EventModel event) throws IOException {
        MessageModel message = event.getMessage();
        if (message != null) {
            if (message.getAttributes() != null) {
                bindingBuilder.addBinding(ATTRIBUTES_ID, this.asTypedValue(message.getAttributes()));
            }
            if (message.getPayload() != null) {
                bindingBuilder.addBinding(PAYLOAD_ID, this.asTypedValue(message.getPayload()));
            }
        }
    }

    private void manageVariables(BindingContext.Builder bindingBuilder, EventModel event) throws IOException {
        if (event.getVariables() != null && !event.getVariables().isEmpty()) {
            HashMap variables = new HashMap();
            for (Map.Entry pair : event.getVariables().entrySet()) {
                variables.put(pair.getKey(), this.asTypedValue((TypedValueModel)pair.getValue()));
            }
            DataType variablesDataType = DataType.builder().type(Map.class).mediaType("application/java").build();
            bindingBuilder.addBinding(VARIABLES_ID, new TypedValue(variables, variablesDataType));
        }
    }

    private TypedValue<?> asTypedValue(TypedValueModel restTypedValue) throws IOException {
        String mediaType = restTypedValue.getDataType().getMediaType();
        if ("application/java".equals(mediaType)) {
            throw new IllegalArgumentException("Java input not supported, serialize to DW script");
        }
        DataType dataType = DataType.builder().type(String.class).mediaType(mediaType).build();
        return new TypedValue((Object)new String(restTypedValue.getContent(), "UTF-8"), dataType);
    }

    private EventModel getEvent(DataWeavePreviewRequest parameters) {
        return parameters.getEvent();
    }

    private String getScript(DataWeavePreviewRequest parameters) {
        return parameters.getScript();
    }
}

