/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.api.XmlConfigurationDocumentLoader;
import org.mule.runtime.config.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.api.dsl.processor.ConfigFile;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.config.api.dsl.xml.StaticXmlNamespaceInfo;
import org.mule.runtime.config.api.dsl.xml.StaticXmlNamespaceInfoProvider;
import org.mule.runtime.config.internal.dsl.model.ClassLoaderResourceProvider;
import org.mule.runtime.config.internal.util.ComponentBuildingDefinitionUtils;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.ApplicationModelFactory;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;
import org.w3c.dom.Document;

public class DefaultApplicationModelFactory
implements ApplicationModelFactory {
    private ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader;

    public DefaultApplicationModelFactory(ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        this.componentBuildingDefinitionLoader = componentBuildingDefinitionLoader;
    }

    @Override
    public Optional<ApplicationModel> createApplicationModel(ApplicationDescriptor applicationDescriptor, Set<ExtensionModel> extensionModels, ClassLoader applicationClassLoader) {
        try {
            return Optional.of(this.loadApplicationModel(applicationDescriptor.getConfigResources().stream().map(configFile -> {
                InputStream configAsStream = applicationClassLoader.getResourceAsStream((String)configFile);
                if (configAsStream == null) {
                    throw new ToolingException(String.format("Configuration file '%s' cannot be found on application class loader", configFile));
                }
                return this.loadConfigFile(applicationDescriptor, (String)configFile, configAsStream, extensionModels).get();
            }).collect(Collectors.toList()), extensionModels, applicationClassLoader));
        }
        catch (Exception e) {
            throw new ToolingException((Throwable)e);
        }
    }

    private Optional<ConfigFile> loadConfigFile(ApplicationDescriptor applicationDescriptor, String fileName, InputStream inputStream, Set<ExtensionModel> extensionModels) {
        return (Optional)ClassUtils.withContextClassLoader((ClassLoader)this.getClass().getClassLoader(), () -> {
            ImmutableList xmlNamespaceInfoProviders = ImmutableList.builder().add((Object)this.createStaticNamespaceInfoProviders(extensionModels)).addAll(this.discoverRuntimeXmlNamespaceInfoProvider()).build();
            XmlApplicationParser xmlApplicationParser = new XmlApplicationParser((List)xmlNamespaceInfoProviders);
            Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(fileName, inputStream);
            return xmlApplicationParser.parse(document.getDocumentElement()).map(configLine -> new ConfigFile(this.relativizeConfigFileName(applicationDescriptor, fileName), Collections.singletonList(configLine)));
        });
    }

    private List<XmlNamespaceInfoProvider> discoverRuntimeXmlNamespaceInfoProvider() {
        ImmutableList.Builder namespaceInfoProvidersBuilder = ImmutableList.builder();
        namespaceInfoProvidersBuilder.addAll((Iterable)new SpiServiceRegistry().lookupProviders(XmlNamespaceInfoProvider.class, this.getClass().getClassLoader()));
        return namespaceInfoProvidersBuilder.build();
    }

    private XmlNamespaceInfoProvider createStaticNamespaceInfoProviders(Set<ExtensionModel> extensionModels) {
        List extensionNamespaces = (List)extensionModels.stream().map(ext -> new StaticXmlNamespaceInfo(ext.getXmlDslModel().getNamespace(), ext.getXmlDslModel().getPrefix())).collect(org.mule.runtime.api.util.collection.Collectors.toImmutableList());
        return new StaticXmlNamespaceInfoProvider((Collection)extensionNamespaces);
    }

    private String relativizeConfigFileName(ApplicationDescriptor applicationDescriptor, String fileName) {
        if (fileName == null) {
            return null;
        }
        return applicationDescriptor.getConfigResources().stream().filter(relativeConfigFileName -> relativeConfigFileName.endsWith(fileName)).findFirst().orElse(null);
    }

    private ApplicationModel loadApplicationModel(List<ConfigFile> configFiles, Set<ExtensionModel> extensionModels, ClassLoader applicationClassLoader) throws Exception {
        ArtifactConfig.Builder builder = new ArtifactConfig.Builder();
        if (!configFiles.isEmpty()) {
            configFiles.forEach(configFile -> builder.addConfigFile(configFile));
        }
        ArtifactConfig artifactConfig = builder.build();
        ApplicationModel applicationModel = new ApplicationModel(artifactConfig, null, extensionModels, Collections.emptyMap(), Optional.of(new EmptyConfigurationProperties()), Optional.of(DefaultApplicationModelFactory.createComponentBuildingDefinitionRegistry(extensionModels, this.componentBuildingDefinitionLoader)), false, (ResourceProvider)new ClassLoaderResourceProvider(applicationClassLoader));
        return applicationModel;
    }

    private static ComponentBuildingDefinitionRegistry createComponentBuildingDefinitionRegistry(Set<ExtensionModel> extensionModels, ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        SpiServiceRegistry serviceRegistry = new SpiServiceRegistry();
        ComponentBuildingDefinitionRegistry componentBuildingDefinitionRegistry = new ComponentBuildingDefinitionRegistry();
        ComponentBuildingDefinitionUtils.registerComponentBuildingDefinitions((ServiceRegistry)serviceRegistry, (ClassLoader)DefaultApplicationModelFactory.class.getClassLoader(), (ComponentBuildingDefinitionRegistry)componentBuildingDefinitionRegistry, Optional.ofNullable(extensionModels), componentBuildingDefinitionLoader.loadComponentBuildingDefinitions(extensionModels));
        return componentBuildingDefinitionRegistry;
    }

    private class EmptyConfigurationProperties
    implements ConfigurationProperties {
        private EmptyConfigurationProperties() {
        }

        public <T> Optional<T> resolveProperty(String s) {
            return Optional.of("");
        }

        public Optional<Boolean> resolveBooleanProperty(String s) {
            return Optional.of(false);
        }

        public Optional<String> resolveStringProperty(String s) {
            return Optional.of("");
        }
    }
}

