/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.io.Files;
import com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.tooling.ToolingArtifactClassLoader;
import org.mule.runtime.deployment.model.internal.tooling.ToolingPluginClassLoaderBuilder;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.artifact.ExtensionModelDiscoverer;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleExtensionModelLoaderManager;
import org.mule.runtime.module.extension.internal.capability.xml.schema.DefaultExtensionSchemaGenerator;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;

public class DefaultExtensionModelService
implements InternalExtensionModelService {
    private ExtensionModelDiscoverer extensionModelDiscoverer = new ExtensionModelDiscoverer();
    private MavenClient mavenClient;
    private MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;
    private ExtensionSchemaGenerator schemaGenerator = new DefaultExtensionSchemaGenerator();

    public DefaultExtensionModelService(MavenClient mavenClient, MuleArtifactResourcesRegistry muleArtifactResourcesRegistry) {
        Objects.requireNonNull(mavenClient, "mavenClient cannot be null");
        Objects.requireNonNull(muleArtifactResourcesRegistry, "muleArtifactResourcesRegistry cannot be null");
        this.mavenClient = mavenClient;
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
    }

    @Override
    public List<ExtensionModel> loadMuleExtensionModels() {
        return Arrays.asList(MuleExtensionModelProvider.getExtensionModel(), MuleEeExtensionModelProvider.getExtensionModel());
    }

    private Optional<LoadedExtensionInformation> resolveExtensionModel(ArtifactPluginDescriptor artifactPluginDescriptor) throws IOException, MuleException {
        ToolingPluginClassLoaderBuilder builder = new ToolingPluginClassLoaderBuilder(this.muleArtifactResourcesRegistry.newTemporaryArtifactClassLoaderFactory(), this.muleArtifactResourcesRegistry.getPluginDependenciesResolver(), artifactPluginDescriptor, this.muleArtifactResourcesRegistry.getRegionPluginClassLoadersFactory());
        builder.setParentClassLoader(this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader());
        ToolingArtifactClassLoader toolingArtifactClassLoader = builder.build();
        MuleExtensionModelLoaderManager extensionModelLoaderRepository = new MuleExtensionModelLoaderManager(this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader());
        extensionModelLoaderRepository.start();
        return this.getLoadedExtensionInformation(artifactPluginDescriptor, toolingArtifactClassLoader, extensionModelLoaderRepository);
    }

    private Optional<LoadedExtensionInformation> getLoadedExtensionInformation(ArtifactPluginDescriptor pluginDescriptor, ToolingArtifactClassLoader toolingArtifactCL, MuleExtensionModelLoaderManager loaderRepository) {
        Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions = this.discoverExtensions(toolingArtifactCL, loaderRepository);
        Optional<ExtensionModel> foundExtension = this.getExtensionModel(pluginDescriptor, descriptorsWithExtensions);
        if (foundExtension.isPresent()) {
            LazyValue<String> lazySchema = this.getSchema(descriptorsWithExtensions, foundExtension.get());
            return Optional.of(new LoadedExtensionInformation(foundExtension.get(), (ArtifactClassLoader)toolingArtifactCL, lazySchema));
        }
        toolingArtifactCL.dispose();
        return Optional.empty();
    }

    private LazyValue<String> getSchema(Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions, ExtensionModel foundExtension) {
        Set extensions = descriptorsWithExtensions.stream().map(Pair::getSecond).collect(Collectors.toSet());
        return new LazyValue(() -> this.schemaGenerator.generate(foundExtension, DslResolvingContext.getDefault((Set)extensions)));
    }

    private Optional<ExtensionModel> getExtensionModel(ArtifactPluginDescriptor descriptor, Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> descriptorsWithExtensions) {
        if (descriptorsWithExtensions.isEmpty()) {
            return Optional.empty();
        }
        return descriptorsWithExtensions.stream().filter(e -> ((ArtifactPluginDescriptor)e.getFirst()).equals(descriptor)).map(Pair::getSecond).findFirst();
    }

    private Set<Pair<ArtifactPluginDescriptor, ExtensionModel>> discoverExtensions(ToolingArtifactClassLoader toolingArtifactCL, MuleExtensionModelLoaderManager extensionModelLoaderRepository) {
        List artifacts = toolingArtifactCL.getArtifactPluginClassLoaders().stream().map(a -> new Pair((Object)a.getArtifactDescriptor(), a)).collect(Collectors.toList());
        return this.extensionModelDiscoverer.discoverExtensionModels((ExtensionModelLoaderRepository)extensionModelLoaderRepository, artifacts);
    }

    @Override
    public Optional<LoadedExtensionInformation> loadExtensionData(ArtifactDescriptor pluginDescriptor) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder();
        builder.setGroupId(pluginDescriptor.getGroupId()).setArtifactId(pluginDescriptor.getArtifactId()).setType(pluginDescriptor.getExtension()).setVersion(pluginDescriptor.getVersion()).setClassifier(pluginDescriptor.getClassifier()).build();
        return this.loadExtensionData(new File(this.mavenClient.resolveBundleDescriptor(builder.build()).getBundleUri()));
    }

    @Override
    public Optional<LoadedExtensionInformation> loadExtensionData(File file) {
        File tempFolder = Files.createTempDir();
        try {
            ArtifactPluginDescriptor artifactPluginDescriptor = this.muleArtifactResourcesRegistry.getArtifactPluginDescriptorLoader().load(file);
            Optional<LoadedExtensionInformation> optional = this.resolveExtensionModel(artifactPluginDescriptor);
            return optional;
        }
        catch (Exception e) {
            throw new ToolingException("Error while loading ExtensionModel for plugin: " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFolder);
        }
    }
}

