/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import org.mule.tooling.client.api.artifact.ToolingArtifact;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.datasense.DataSenseService;
import org.mule.tooling.client.api.dataweave.DataWeaveService;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.DefaultConnectivityTestingService;
import org.mule.tooling.client.internal.DefaultDataSenseService;
import org.mule.tooling.client.internal.DefaultValueProviderService;
import org.mule.tooling.client.internal.InternalMetadataProvider;
import org.mule.tooling.client.internal.ToolingMetadataServiceAdapter;
import org.mule.tooling.client.internal.application.Application;
import org.mule.tooling.client.internal.dataweave.DataWeaveRunnerProvider;
import org.mule.tooling.client.internal.dataweave.DefaultDataWeaveService;
import org.mule.tooling.client.internal.dataweave.ModulesAnalyzer;
import org.mule.tooling.client.internal.dataweave.RemoteRunner;

public class DefaultToolingArtifact
implements ToolingArtifact {
    private String id;
    private Application application;
    private ConnectivityTestingService connectivityTestingService;
    private MetadataService metadataService;
    private DataSenseService dataSenseService;
    private DataWeaveService dataWeaveService;
    private ValueProviderService valueProviderService;

    public DefaultToolingArtifact(String id, Application application) {
        Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        Preconditions.checkNotNull((Object)application, (Object)"application cannot be null");
        this.id = id;
        this.application = application;
        this.connectivityTestingService = new DefaultConnectivityTestingService(application);
        InternalMetadataProvider metadataProvider = new InternalMetadataProvider(application);
        this.metadataService = new ToolingMetadataServiceAdapter(metadataProvider);
        this.dataSenseService = new DefaultDataSenseService(application, metadataProvider);
        RemoteRunner remoteRunner = new RemoteRunner(application);
        this.dataWeaveService = new DefaultDataWeaveService(new DataWeaveRunnerProvider(remoteRunner), new ModulesAnalyzer());
        this.valueProviderService = new DefaultValueProviderService(application);
    }

    public String getId() {
        return this.id;
    }

    public ConnectivityTestingService connectivityTestingService() {
        return this.connectivityTestingService;
    }

    public MetadataService metadataService() {
        return this.metadataService;
    }

    public DataSenseService dataSenseService() {
        return this.dataSenseService;
    }

    public DataWeaveService dataweaveService() {
        return this.dataWeaveService;
    }

    public ValueProviderService valueProviderService() {
        return this.valueProviderService;
    }

    public void dispose() {
        this.application.dispose();
    }
}

