/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.LoadedExtensionInformation;
import org.mule.tooling.client.internal.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelServiceCache
implements Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE = "tooling.client.ExtensionModelServiceCache.cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelServiceCache.class);
    private List<ExtensionModel> muleExtensionModels;
    private Cache<ArtifactDescriptor, Optional<LoadedExtensionInformation>> extensionModelsByArtifact = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).removalListener(notification -> ((Optional)notification.getValue()).ifPresent(data -> this.closeClassLoader(data.getArtifactClassLoader()))).build();
    private Cache<File, Optional<LoadedExtensionInformation>> extensionModelsByFile = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).removalListener(notification -> ((Optional)notification.getValue()).ifPresent(data -> this.closeClassLoader(data.getArtifactClassLoader()))).build();

    private Integer cacheMaximumSize() {
        Integer cacheSize = Integer.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE, "100"));
        Preconditions.checkArgument((cacheSize > 0 ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, the cache cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE));
        return cacheSize;
    }

    public Optional<ExtensionModel> loadExtensionModel(ArtifactDescriptor artifact, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> ((Optional)this.extensionModelsByArtifact.get((Object)artifact, () -> extensionModelService.loadExtensionData(artifact))).map(LoadedExtensionInformation::getExtensionModel));
    }

    public Optional<ExtensionModel> loadExtensionModel(File plugin, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> ((Optional)this.extensionModelsByFile.get((Object)plugin, () -> extensionModelService.loadExtensionData(plugin))).map(LoadedExtensionInformation::getExtensionModel));
    }

    public Optional<String> loadExtensionSchema(File plugin, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> ((Optional)this.extensionModelsByFile.get((Object)plugin, () -> extensionModelService.loadExtensionData(plugin))).map(e -> (String)e.getSchema().get()));
    }

    public Optional<String> loadExtensionSchema(ArtifactDescriptor artifact, InternalExtensionModelService extensionModelService) {
        return ServiceUtils.executeHandlingException(() -> ((Optional)this.extensionModelsByArtifact.get((Object)artifact, () -> extensionModelService.loadExtensionData(artifact))).map(e -> (String)e.getSchema().get()));
    }

    public List<ExtensionModel> loadMuleExtensionModels(InternalExtensionModelService extensionModelService) {
        if (this.muleExtensionModels == null) {
            this.muleExtensionModels = extensionModelService.loadMuleExtensionModels();
        }
        return this.muleExtensionModels;
    }

    private void closeClassLoader(ArtifactClassLoader artifactClassLoader) {
        block2: {
            try {
                artifactClassLoader.dispose();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.extensionModelsByFile.invalidateAll();
        this.extensionModelsByArtifact.invalidateAll();
    }
}

