/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.net.URL;
import java.util.Objects;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.application.ApplicationDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplicationDeployer
implements ApplicationDeployer {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private URL applicationUrlContent;
    private RuntimeToolingService runtimeToolingService;

    public AbstractApplicationDeployer(URL applicationUrlContent, RuntimeToolingService runtimeToolingService) {
        Objects.requireNonNull(applicationUrlContent, "applicationUrlContent cannot be null");
        Objects.requireNonNull(runtimeToolingService, "runtimeToolingService cannot be null");
        this.applicationUrlContent = applicationUrlContent;
        this.runtimeToolingService = runtimeToolingService;
    }

    @Override
    public String deploy() {
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Deploying application to Mule Runtime");
        }
        String applicationId = this.doInternalInit(this.applicationUrlContent, this.runtimeToolingService);
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Application deployed with applicationId: {}", (Object)applicationId);
        }
        return applicationId;
    }

    protected abstract String doInternalInit(URL var1, RuntimeToolingService var2);
}

