/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.dsl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.maven.client.api.MavenClient;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;
import org.mule.tooling.client.internal.utils.ExtensionModelUtils;
import org.mule.tooling.client.internal.utils.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DslSyntaxServiceCache {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE = "tooling.client.DslSyntaxServiceCache.cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(DslSyntaxServiceCache.class);
    private final LoadingCache<List<ArtifactDescriptor>, DslResolvingContext> dslContextCache;
    private final Cache<ExtensionModel, DslSyntaxResolver> dslResolverCache;

    public DslSyntaxServiceCache(final MavenClient mavenClient, final MuleRuntimeExtensionModelProvider muleRuntimeExtensionModelProvider) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Initialising DSL Syntax cache");
        }
        this.dslContextCache = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<List<ArtifactDescriptor>, DslResolvingContext>(){

            public DslResolvingContext load(List<ArtifactDescriptor> artifacts) throws Exception {
                return ExtensionModelUtils.createDslResolvingContext(muleRuntimeExtensionModelProvider.getMuleExtensionModels(), ExtensionModelUtils.resolveExtensionModels(mavenClient, muleRuntimeExtensionModelProvider, artifacts));
            }
        });
        this.dslResolverCache = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).expireAfterWrite(10L, TimeUnit.MINUTES).weakKeys().build();
    }

    private Integer cacheMaximumSize() {
        Integer cacheSize = Integer.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE, "100"));
        Preconditions.checkArgument((cacheSize > 0 ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, the cache cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE));
        return cacheSize;
    }

    public DslResolvingContext getContext(List<ArtifactDescriptor> artifactDescriptors) {
        return ServiceUtils.executeHandlingException(() -> (DslResolvingContext)this.dslContextCache.get((Object)artifactDescriptors));
    }

    public DslSyntaxResolver getResolver(ExtensionModel extensionModel, DslResolvingContext context) {
        return ServiceUtils.executeHandlingException(() -> (DslSyntaxResolver)this.dslResolverCache.get((Object)extensionModel, () -> DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)context)));
    }

    public void invalidate(List<ArtifactDescriptor> plugins) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invalidating DSL Context cache");
        }
        try {
            ((DslResolvingContext)this.dslContextCache.get(plugins)).getExtensions().forEach(arg_0 -> this.dslResolverCache.invalidate(arg_0));
            this.dslContextCache.invalidate(plugins);
        }
        catch (Exception e) {
            LOGGER.error("Failed to invalidate the DSL Context cache: " + e.getMessage(), (Throwable)e);
            this.invalidate();
        }
    }

    public void invalidate(List<ArtifactDescriptor> plugins, org.mule.tooling.client.api.extension.model.ExtensionModel toolingModel) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invalidating DSL Resolvers cache for extension: " + toolingModel.getName());
        }
        try {
            ((DslResolvingContext)this.dslContextCache.get(plugins)).getExtension(toolingModel.getName()).ifPresent(arg_0 -> this.dslResolverCache.invalidate(arg_0));
        }
        catch (Exception e) {
            LOGGER.error("Failed to invalidate the DSL Resolvers cache: " + e.getMessage(), (Throwable)e);
            this.invalidate();
        }
    }

    public void invalidate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invalidating DSL Syntax cache");
        }
        try {
            this.dslContextCache.invalidateAll();
            this.dslResolverCache.invalidateAll();
        }
        catch (Exception e) {
            LOGGER.error("Failed to invalidate the DSL Syntax cache: " + e.getMessage(), (Throwable)e);
        }
    }
}

