/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.utils;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static <T> T executeHandlingException(ResourceSupplier<T> supplier) {
        try {
            return supplier.getResource();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface ResourceSupplier<T> {
        public T getResource() throws ExecutionException;
    }
}

