/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal;

import static java.util.Objects.requireNonNull;
import static java.util.Optional.empty;
import static org.mule.tooling.client.internal.TimeoutMethodUtils.withTimeout;
import org.mule.tooling.client.api.connectivity.ConnectionValidationResult;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingObjectNotFoundException;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingRequest;
import org.mule.tooling.client.api.connectivity.ConnectivityTestingService;
import org.mule.tooling.client.api.connectivity.UnsupportedConnectivityTestingObjectException;
import org.mule.tooling.client.api.exception.NoSuchApplicationException;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;

/**
 * Default implementation of {@link ConnectivityTestingService}.
 *
 * @since 4.0
 */
public class DefaultConnectivityTestingService implements ConnectivityTestingService {

  private RemoteApplicationInvoker remoteApplicationInvoker;

  /**
   * Creates an instance of the service.
   *
   * @param remoteApplicationInvoker {@link RemoteApplicationInvoker} to deploy and resolve operations against a Mule Runtime. Non null.
   */
  public DefaultConnectivityTestingService(RemoteApplicationInvoker remoteApplicationInvoker) {
    requireNonNull(remoteApplicationInvoker, "remoteApplicationInvoker cannot be null");

    this.remoteApplicationInvoker = remoteApplicationInvoker;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ConnectionValidationResult testConnection(ConnectivityTestingRequest connectivityTestingRequest)
      throws NoSuchApplicationException, UnsupportedConnectivityTestingObjectException,
      ConnectivityTestingObjectNotFoundException, ToolingException, ServiceUnavailableException {
    return withTimeout(connectivityTestingRequest.getRequestTimeout(),
                       () -> remoteApplicationInvoker
                           .evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService
                               .testConnection(applicationId,
                                               connectivityTestingRequest.getComponentId())),
                       empty(),
                       empty());
  }

}
