/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

/**
 * This class carries information about an extension that was loaded.
 *
 * @since 1.0
 */
public class LoadedExtensionInformation {

  private ExtensionModel extensionModel;
  private ArtifactClassLoader artifactClassLoader;
  private LazyValue<String> schema;

  public LoadedExtensionInformation(ExtensionModel extensionModel, ArtifactClassLoader artifactClassLoader,
                                    LazyValue<String> schema) {
    this.extensionModel = extensionModel;
    this.artifactClassLoader = artifactClassLoader;
    this.schema = schema;
  }

  /**
   * @return the {@link ExtensionModel} associated to the extension that was loaded.
   */
  public ExtensionModel getExtensionModel() {
    return extensionModel;
  }

  /**
   * @return returns the {@link ArtifactClassLoader} of the loaded extension.
   */
  public ArtifactClassLoader getArtifactClassLoader() {
    return artifactClassLoader;
  }

  /**
   * @return returns a {@link LazyValue} that calculates the schema when it gets called.
   */
  public LazyValue<String> getSchema() {
    return schema;
  }

  @Override
  public int hashCode() {
    return HashCodeBuilder.reflectionHashCode(this);
  }

  @Override
  public boolean equals(Object obj) {
    return EqualsBuilder.reflectionEquals(this, obj);
  }
}
