/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mule.runtime.api.util.LazyValue;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.agent.rest.client.tooling.applications.applicationName.tryIt.AgentTrackingNotificationResponse;
import org.mule.tooling.client.api.tryit.MessageHistory;
import org.mule.tooling.client.api.tryit.TryItService;
import org.mule.tooling.client.api.types.Transaction;
import org.mule.tooling.client.api.types.TransactionStackEntry;
import org.mule.tooling.client.api.types.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTryItService
implements TryItService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String FIRST_MESSAGE_PROCESSOR_INDEX = "/0";
    private static final String MESSAGE_PRE_INVOKE_ACTION = "message processor pre invoke";
    private static final String MESSAGE_POST_INVOKE_ACTION = "message processor post invoke";
    private LazyValue<RuntimeToolingService> runtimeToolingServiceLazyValue;

    protected DefaultTryItService(LazyValue<RuntimeToolingService> runtimeToolingServiceLazyValue) {
        Objects.requireNonNull(runtimeToolingServiceLazyValue, "runtimeToolingServiceLazyValue cannot be null");
        this.runtimeToolingServiceLazyValue = runtimeToolingServiceLazyValue;
    }

    public void enable(String applicationName) {
        ((RuntimeToolingService)this.runtimeToolingServiceLazyValue.get()).enableTryIt(applicationName);
    }

    public MessageHistory consume(String applicationName, int chunkSize) {
        List agentTrackingNotifications = ((RuntimeToolingService)this.runtimeToolingServiceLazyValue.get()).consumeTryItNotifications(applicationName, chunkSize);
        return this.convertToMessageHistory(agentTrackingNotifications);
    }

    private MessageHistory convertToMessageHistory(List<AgentTrackingNotificationResponse> agentTrackingNotifications) {
        MessageHistory messageHistory = new MessageHistory();
        ArrayList transactions = new ArrayList();
        messageHistory.setTransactions(transactions);
        Map<String, List<AgentTrackingNotificationResponse>> notificationsMap = this.splitAgentNotificationsAndSortByDate(agentTrackingNotifications);
        notificationsMap.keySet().stream().forEach(transactionId -> {
            List transactionNotifications = (List)notificationsMap.get(transactionId);
            Transaction transaction = new Transaction();
            transaction.setTransactionStatus(TransactionStatus.COMPLETE);
            transaction.setId(((AgentTrackingNotificationResponse)transactionNotifications.get(0)).getTransactionId());
            AgentTrackingNotificationResponse firstMessageProcessorInputNotification = (AgentTrackingNotificationResponse)transactionNotifications.get(0);
            if (firstMessageProcessorInputNotification.getComponentLocation().getLocation().endsWith(FIRST_MESSAGE_PROCESSOR_INDEX) && firstMessageProcessorInputNotification.getAction().equals(MESSAGE_PRE_INVOKE_ACTION)) {
                transaction.setMessage(firstMessageProcessorInputNotification.getEvent().getMessage());
                transaction.setTimestamp(firstMessageProcessorInputNotification.getTimestamp());
            }
            transaction.setTransactionStack(transactionNotifications.stream().filter(agentTrackingNotification -> agentTrackingNotification.getAction().equals(MESSAGE_POST_INVOKE_ACTION)).map(agentTrackingNotification -> {
                TransactionStackEntry transactionStackEntry = new TransactionStackEntry();
                transactionStackEntry.setTimestamp(agentTrackingNotification.getTimestamp());
                transactionStackEntry.setComponentLocation(agentTrackingNotification.getComponentLocation());
                transactionStackEntry.setEventModel(agentTrackingNotification.getEvent());
                return transactionStackEntry;
            }).collect(Collectors.toList()));
            transactions.add(transaction);
        });
        return messageHistory;
    }

    private Map<String, List<AgentTrackingNotificationResponse>> splitAgentNotificationsAndSortByDate(List<AgentTrackingNotificationResponse> agentTrackingNotifications) {
        this.logger.debug("Grouping notifications by correlationId");
        HashMap<String, List<AgentTrackingNotificationResponse>> notificationsMap = new HashMap<String, List<AgentTrackingNotificationResponse>>();
        agentTrackingNotifications.stream().forEach(agentTrackingNotification -> {
            this.logger.debug("Processing notification: {}", agentTrackingNotification);
            ArrayList<AgentTrackingNotificationResponse> notifications = (ArrayList<AgentTrackingNotificationResponse>)notificationsMap.get(agentTrackingNotification.getCorrelationId());
            if (notifications == null) {
                notifications = new ArrayList<AgentTrackingNotificationResponse>();
                notificationsMap.put(agentTrackingNotification.getCorrelationId(), notifications);
            }
            notifications.add((AgentTrackingNotificationResponse)agentTrackingNotification);
        });
        for (List transactinAgentNotifications : notificationsMap.values()) {
            Collections.sort(transactinAgentNotifications, Comparator.comparingLong(AgentTrackingNotificationResponse::getTimestamp));
        }
        return notificationsMap;
    }

    public void disable(String applicationName) {
        try {
            ((RuntimeToolingService)this.runtimeToolingServiceLazyValue.get()).disableTryIt(applicationName);
        }
        catch (Exception e) {
            this.logger.warn("Error while disabling application for try it", (Throwable)e);
        }
    }
}

