/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.mule.runtime.api.value.ResolvingFailure;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.TimeoutMethodUtils;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;

public class DefaultValueProviderService
implements ValueProviderService {
    private static final String DEPLOYMENT = "DEPLOYMENT";
    private RemoteApplicationInvoker remoteApplicationInvoker;

    public DefaultValueProviderService(RemoteApplicationInvoker remoteApplicationInvoker) {
        Preconditions.checkNotNull((Object)remoteApplicationInvoker, (Object)"remoteApplicationInvoker cannot be null");
        this.remoteApplicationInvoker = remoteApplicationInvoker;
    }

    public ValueResult getValues(ValueProviderRequest valueProviderRequest) {
        return TimeoutMethodUtils.withTimeout(valueProviderRequest.getRequestTimeout(), () -> this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.getValues(applicationId, valueProviderRequest.getLocation(), valueProviderRequest.getProviderName())), Optional.of(throwable -> ValueResult.resultFrom((ResolvingFailure)this.getFailure((Throwable)throwable))), Optional.empty());
    }

    ResolvingFailure getFailure(Throwable throwable) {
        String failureCode = "UNKNOWN";
        if (throwable instanceof CompletionException && throwable.getCause() instanceof DeploymentException) {
            failureCode = DEPLOYMENT;
        }
        return ResolvingFailure.Builder.newFailure((Throwable)throwable).withFailureCode(failureCode).build();
    }
}

