/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.maven.client.api.MavenClient;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.internal.MuleRuntimeExtensionModelProvider;

import java.net.URL;
import java.util.function.Supplier;

/**
 * Represents an {@link Application} already deployed and fetched.
 */
public class FetchedApplication extends Application {

  private final Deployable deployable;

  public FetchedApplication(String applicationId, Supplier<URL> applicationUrlContentSupplier,
                            Supplier<RuntimeToolingService> runtimeToolingServiceSupplier,
                            MavenClient mavenClient,
                            MuleRuntimeExtensionModelProvider runtimeExtensionModelProvider) {
    super(applicationUrlContentSupplier, runtimeToolingServiceSupplier, mavenClient, runtimeExtensionModelProvider);
    this.applicationId = applicationId;
    this.deployable =
        new ImmutableApplicationDeployable(applicationId, applicationUrlContentSupplier, runtimeToolingServiceSupplier);
  }

  @Override
  public Deployable deploy() {
    return deployable;
  }

}
