/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.api.metadata.dto.FailureCode;
import org.mule.tooling.client.api.metadata.dto.MetadataComponent;
import org.mule.tooling.client.api.metadata.dto.MetadataFailure;
import org.mule.tooling.client.api.metadata.dto.MetadataKey;
import org.mule.tooling.client.internal.MetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingMetadataServiceAdapter
implements MetadataService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MetadataProvider metadataProvider;

    public ToolingMetadataServiceAdapter(MetadataProvider metadataProvider) {
        Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        this.metadataProvider = metadataProvider;
    }

    private static MetadataKey metadataKeyToDTO(org.mule.runtime.api.metadata.MetadataKey metadataKey) {
        if (metadataKey == null) {
            return null;
        }
        Set children = metadataKey.getChilds().stream().map(ToolingMetadataServiceAdapter::metadataKeyToDTO).collect(Collectors.toSet());
        return new MetadataKey(metadataKey.getId(), metadataKey.getDisplayName(), children, metadataKey.getPartName());
    }

    private static org.mule.tooling.client.api.metadata.dto.MetadataKeysContainer toMetadataKeysContainerDTO(MetadataKeysContainer container) {
        Map map = container.getKeysByCategory();
        HashMap dtomap = new HashMap();
        for (String key : map.keySet()) {
            Set set = ((Set)map.get(key)).stream().map(ToolingMetadataServiceAdapter::metadataKeyToDTO).collect(Collectors.toSet());
            dtomap.put(key, set);
        }
        return new org.mule.tooling.client.api.metadata.dto.MetadataKeysContainer(dtomap);
    }

    private static MetadataComponent toMetadataComponentDTO(org.mule.runtime.api.metadata.resolving.MetadataComponent component) {
        if (component.equals((Object)org.mule.runtime.api.metadata.resolving.MetadataComponent.OUTPUT_ATTRIBUTES)) {
            return new MetadataComponent(component.name(), false, true, false, false, false, false, false);
        }
        if (component.equals((Object)org.mule.runtime.api.metadata.resolving.MetadataComponent.OUTPUT_PAYLOAD)) {
            return new MetadataComponent(component.name(), false, false, true, false, false, false, false);
        }
        if (component.equals((Object)org.mule.runtime.api.metadata.resolving.MetadataComponent.INPUT)) {
            return new MetadataComponent(component.name(), false, false, false, true, false, false, false);
        }
        if (component.equals((Object)org.mule.runtime.api.metadata.resolving.MetadataComponent.COMPONENT)) {
            return new MetadataComponent(component.name(), false, false, false, false, true, false, false);
        }
        if (component.equals((Object)org.mule.runtime.api.metadata.resolving.MetadataComponent.ENTITY)) {
            return new MetadataComponent(component.name(), false, false, false, false, false, true, false);
        }
        if (component.equals((Object)org.mule.runtime.api.metadata.resolving.MetadataComponent.KEYS)) {
            return new MetadataComponent(component.name(), false, false, false, false, false, false, true);
        }
        return new MetadataComponent(component.name(), true, false, false, false, false, false, false);
    }

    private static org.mule.tooling.client.api.metadata.dto.MetadataResult toMetadataResultDTO(MetadataResult result, Supplier<Object> supplier) {
        if (result.isSuccess()) {
            return org.mule.tooling.client.api.metadata.dto.MetadataResult.success((Object)supplier.get());
        }
        List failures = result.getFailures();
        return org.mule.tooling.client.api.metadata.dto.MetadataResult.failure(failures.stream().map(failure -> new MetadataFailure(ToolingMetadataServiceAdapter.toMetadataComponentDTO(failure.getFailingComponent()), failure.getFailingElement().orElse(""), failure.getMessage(), failure.getReason(), new FailureCode(failure.getFailureCode().getName()))).collect(Collectors.toList()));
    }

    public org.mule.tooling.client.api.metadata.dto.MetadataResult<org.mule.tooling.client.api.metadata.dto.MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException, ToolingException {
        MetadataResult<MetadataKeysContainer> metadataKeys = this.metadataProvider.getMetadataKeys(metadataKeysRequest);
        return ToolingMetadataServiceAdapter.toMetadataResultDTO(metadataKeys, () -> ToolingMetadataServiceAdapter.toMetadataKeysContainerDTO((MetadataKeysContainer)metadataKeys.get()));
    }
}

