/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.operation.RouterModel;
import org.mule.runtime.api.meta.model.operation.ScopeModel;
import org.mule.tooling.client.api.extension.model.ImportedTypeModel;
import org.mule.tooling.client.api.extension.model.MuleVersion;
import org.mule.tooling.client.api.extension.model.SubTypesModel;
import org.mule.tooling.client.api.extension.model.XmlDslModel;
import org.mule.tooling.client.api.extension.model.config.ConfigurationModel;
import org.mule.tooling.client.api.extension.model.connection.ConnectionProviderModel;
import org.mule.tooling.client.api.extension.model.function.FunctionModel;
import org.mule.tooling.client.api.extension.model.source.SourceModel;
import org.mule.tooling.client.internal.CollectionUtils;
import org.mule.tooling.client.internal.ExtensionModelPartsFactory;

public class ExtensionModelFactory {
    private Map<String, ConnectionProviderModel> connectionProviderModelsCache = Maps.newHashMap();
    private Map<String, SourceModel> sourceModelsCache = Maps.newHashMap();
    private Map<String, org.mule.tooling.client.api.extension.model.operation.OperationModel> operationModelsCache = Maps.newHashMap();
    private Map<String, org.mule.tooling.client.api.extension.model.operation.ScopeModel> scopeModelsCache = Maps.newHashMap();
    private Map<String, org.mule.tooling.client.api.extension.model.operation.RouterModel> routerModelsCache = Maps.newHashMap();
    private Map<String, FunctionModel> functionModelsCache = Maps.newHashMap();

    public org.mule.tooling.client.api.extension.model.ExtensionModel createExtensionModel(ExtensionModel runtimeExtensionModel) {
        return new org.mule.tooling.client.api.extension.model.ExtensionModel(runtimeExtensionModel.getName(), ExtensionModelFactory.toCategoryDTO(runtimeExtensionModel.getCategory()), new MuleVersion(runtimeExtensionModel.getMinMuleVersion().toCompleteNumericVersion()), runtimeExtensionModel.getVendor(), CollectionUtils.copy(runtimeExtensionModel.getResources()), runtimeExtensionModel.getImportedTypes().stream().map(importedTypeModel -> new ImportedTypeModel(importedTypeModel.getImportedType())).collect(Collectors.toSet()), runtimeExtensionModel.getSubTypes().stream().map(subTypesModel -> new SubTypesModel(subTypesModel.getBaseType(), subTypesModel.getSubTypes())).collect(Collectors.toSet()), runtimeExtensionModel.getTypes(), runtimeExtensionModel.getVersion(), new XmlDslModel(runtimeExtensionModel.getXmlDslModel().getXsdFileName(), runtimeExtensionModel.getXmlDslModel().getSchemaVersion(), runtimeExtensionModel.getXmlDslModel().getPrefix(), runtimeExtensionModel.getXmlDslModel().getNamespace(), runtimeExtensionModel.getXmlDslModel().getSchemaLocation()), runtimeExtensionModel.getDescription(), ExtensionModelPartsFactory.toDisplayModelTO(runtimeExtensionModel.getDisplayModel()), ExtensionModelPartsFactory.toExternalLibraryModelsDTO(runtimeExtensionModel.getExternalLibraryModels()), this.toConfigurationModelsDTO(runtimeExtensionModel), this.toOperationModelsDTO(runtimeExtensionModel.getOperationModels()), this.toConnectionProvidersDTO(runtimeExtensionModel.getConnectionProviders()), this.toSourceModelsDTO(runtimeExtensionModel.getSourceModels()), this.toFunctionModelsDTO(runtimeExtensionModel.getFunctionModels()));
    }

    private static org.mule.tooling.client.api.extension.model.Category toCategoryDTO(Category category) {
        if (category == Category.COMMUNITY) {
            return org.mule.tooling.client.api.extension.model.Category.communityCategory((String)category.name());
        }
        if (category == Category.SELECT) {
            return org.mule.tooling.client.api.extension.model.Category.selectCategory((String)category.name());
        }
        if (category == Category.PREMIUM) {
            return org.mule.tooling.client.api.extension.model.Category.premiumCategory((String)category.name());
        }
        if (category == Category.CERTIFIED) {
            return org.mule.tooling.client.api.extension.model.Category.certifiedCategory((String)category.name());
        }
        return new org.mule.tooling.client.api.extension.model.Category(category.name());
    }

    private List<ConfigurationModel> toConfigurationModelsDTO(ExtensionModel serializedExtensionModel) {
        return serializedExtensionModel.getConfigurationModels().stream().map(configurationModel -> new ConfigurationModel(configurationModel.getName(), configurationModel.getDescription(), ExtensionModelPartsFactory.toParameterGroupModelsDTO(configurationModel.getParameterGroupModels()), this.toOperationModelsDTO(configurationModel.getOperationModels()), ExtensionModelPartsFactory.toExternalLibraryModelsDTO(configurationModel.getExternalLibraryModels()), this.toSourceModelsDTO(configurationModel.getSourceModels()), this.toConnectionProvidersDTO(configurationModel.getConnectionProviders()), ExtensionModelPartsFactory.toDisplayModelTO(configurationModel.getDisplayModel()))).collect(Collectors.toList());
    }

    private List<org.mule.tooling.client.api.extension.model.operation.OperationModel> toOperationModelsDTO(List<OperationModel> operationModels) {
        return operationModels.stream().map(operationModel -> ExtensionModelPartsFactory.toOperationModelDTO(operationModel, new CachedComponentModelVisitorDTO())).collect(Collectors.toList());
    }

    private List<SourceModel> toSourceModelsDTO(List<org.mule.runtime.api.meta.model.source.SourceModel> sourceModels) {
        return sourceModels.stream().map(sourceModel -> sourceModel == null ? null : this.sourceModelsCache.computeIfAbsent(sourceModel.getName(), name -> ExtensionModelPartsFactory.toSourceModelDTO(sourceModel))).collect(Collectors.toList());
    }

    private List<ConnectionProviderModel> toConnectionProvidersDTO(List<org.mule.runtime.api.meta.model.connection.ConnectionProviderModel> connectionProviders) {
        return connectionProviders.stream().map(connectionProviderModel -> this.connectionProviderModelsCache.computeIfAbsent(connectionProviderModel.getName(), name -> ExtensionModelPartsFactory.toConnectionProviderDTO(connectionProviderModel))).collect(Collectors.toList());
    }

    private List<FunctionModel> toFunctionModelsDTO(List<org.mule.runtime.api.meta.model.function.FunctionModel> functionModels) {
        return functionModels.stream().map(functionModel -> this.functionModelsCache.computeIfAbsent(functionModel.getName(), name -> ExtensionModelPartsFactory.toFunctionModelDTO(functionModel))).collect(Collectors.toList());
    }

    private class CachedComponentModelVisitorDTO
    extends ExtensionModelPartsFactory.ComponentModelVisitorDTO {
        private CachedComponentModelVisitorDTO() {
        }

        @Override
        public void visit(OperationModel operationModel) {
            this.operationModelDTO = ExtensionModelFactory.this.operationModelsCache.computeIfAbsent(operationModel.getName(), name -> {
                super.visit(operationModel);
                return this.operationModelDTO;
            });
        }

        @Override
        public void visit(ScopeModel scopeModel) {
            this.operationModelDTO = (org.mule.tooling.client.api.extension.model.operation.OperationModel)ExtensionModelFactory.this.scopeModelsCache.computeIfAbsent(scopeModel.getName(), name -> {
                super.visit(scopeModel);
                return (org.mule.tooling.client.api.extension.model.operation.ScopeModel)this.operationModelDTO;
            });
        }

        @Override
        public void visit(RouterModel routerModel) {
            this.operationModelDTO = (org.mule.tooling.client.api.extension.model.operation.OperationModel)ExtensionModelFactory.this.routerModelsCache.computeIfAbsent(routerModel.getName(), name -> {
                super.visit(routerModel);
                return (org.mule.tooling.client.api.extension.model.operation.RouterModel)this.operationModelDTO;
            });
        }
    }
}

