/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataRequest;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.TimeoutMethodUtils;
import org.mule.tooling.client.internal.application.Deployable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalMetadataProvider
implements MetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Supplier<Deployable> deployableApplicationSupplier;

    public InternalMetadataProvider(Supplier<Deployable> deployableApplicationSupplier) {
        Preconditions.checkNotNull(deployableApplicationSupplier, (Object)"deployableApplicationSupplier cannot be null");
        this.deployableApplicationSupplier = deployableApplicationSupplier;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException, ToolingException {
        Deployable deployable = this.deployableApplicationSupplier.get();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting metadata keys for: {} on application: {}", (Object)metadataKeysRequest, (Object)deployable);
        }
        Supplier<MetadataResult> metadataResultSupplier = () -> {
            MetadataResult result = deployable.getRuntimeToolingService().getMetadataKeys(deployable.getApplicationId(), metadataKeysRequest.getLocation().toString());
            return result;
        };
        return TimeoutMethodUtils.withTimeout(metadataKeysRequest.getRequestTimeout(), metadataResultSupplier, ex -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Exception)ex)).onKeys()}));
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(MetadataRequest metadataRequest) {
        Deployable deployable = this.deployableApplicationSupplier.get();
        Supplier<MetadataResult> metadataResultSupplier = () -> deployable.getRuntimeToolingService().getOperationMetadata(deployable.getApplicationId(), metadataRequest.getLocation().toString());
        return TimeoutMethodUtils.withTimeout(metadataRequest.getRequestTimeout(), () -> this.getMetadata(metadataRequest, deployable, metadataResultSupplier), ex -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Exception)ex)).onComponent()}));
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(MetadataRequest metadataRequest) {
        Deployable deployable = this.deployableApplicationSupplier.get();
        Supplier<MetadataResult> metadataResultSupplier = () -> deployable.getRuntimeToolingService().getSourceMetadata(deployable.getApplicationId(), metadataRequest.getLocation().toString());
        return TimeoutMethodUtils.withTimeout(metadataRequest.getRequestTimeout(), () -> this.getMetadata(metadataRequest, deployable, metadataResultSupplier), ex -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Exception)ex)).onComponent()}));
    }

    private <T extends ComponentModel> MetadataResult<ComponentMetadataDescriptor<T>> getMetadata(MetadataRequest metadataRequest, Deployable deployable, Supplier<MetadataResult<ComponentMetadataDescriptor<T>>> metadataResultSupplier) throws ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting metadata for: {} on application: {}", (Object)metadataRequest, (Object)deployable);
        }
        return TimeoutMethodUtils.withTimeout(metadataRequest.getRequestTimeout(), metadataResultSupplier, ex -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Exception)ex)).onComponent()}));
    }
}

