/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataService;
import org.mule.tooling.client.internal.MetadataPartsFactory;
import org.mule.tooling.client.internal.MetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingMetadataServiceAdapter
implements MetadataService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MetadataProvider metadataProvider;

    public ToolingMetadataServiceAdapter(MetadataProvider metadataProvider) {
        Preconditions.checkNotNull((Object)metadataProvider, (Object)"metadataProvider cannot be null");
        this.metadataProvider = metadataProvider;
    }

    public org.mule.tooling.client.api.metadata.MetadataResult<org.mule.tooling.client.api.metadata.MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException, ToolingException {
        MetadataResult<MetadataKeysContainer> metadataKeys = this.metadataProvider.getMetadataKeys(metadataKeysRequest);
        return MetadataPartsFactory.toMetadataResultDTO(metadataKeys, () -> MetadataPartsFactory.toMetadataKeysContainerDTO((MetadataKeysContainer)metadataKeys.get()));
    }

    public MetadataResult<MetadataKeysContainer> internalMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException, ToolingException {
        return this.metadataProvider.getMetadataKeys(metadataKeysRequest);
    }
}

