/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.tooling.client.api.exception.ToolingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeoutMethodUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutMethodUtils.class);

    public static <T> T withTimeout(long timeout, Supplier<T> resultSupplier, Optional<Function<Throwable, T>> throwableTFunction, Optional<Consumer<TimeoutException>> cleanupFunctionOnTimeout) {
        Preconditions.checkNotNull((Object)timeout, (Object)"request cannot be null");
        Preconditions.checkNotNull(resultSupplier, (Object)"resultSupplier cannot be null");
        CompletionStage<T> completableFuture = CompletableFuture.supplyAsync(resultSupplier);
        if (throwableTFunction.isPresent()) {
            completableFuture = ((CompletableFuture)completableFuture).exceptionally(throwableTFunction.get());
        }
        try {
            if (timeout != -1L) {
                return ((CompletableFuture)completableFuture).get(timeout, TimeUnit.MILLISECONDS);
            }
            return ((CompletableFuture)completableFuture).get();
        }
        catch (TimeoutException e) {
            if (cleanupFunctionOnTimeout.isPresent()) {
                try {
                    cleanupFunctionOnTimeout.get().accept(e);
                }
                catch (Exception internalError) {
                    LOGGER.warn("Error while calling function to clean up resources on a timeout", (Throwable)internalError);
                }
            }
            throw new org.mule.tooling.client.api.exception.TimeoutException("Couldn't resolve the operation in the the expected time frame", (Throwable)e);
        }
        catch (InterruptedException | ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw new ToolingException((Throwable)e);
        }
    }
}

