/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.tooling.ToolingPluginClassLoaderBuilder;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.artifact.ExtensionModelDiscoverer;
import org.mule.runtime.module.deployment.impl.internal.plugin.MuleExtensionModelLoaderManager;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.mule.tooling.client.internal.MuleArtifactResourcesRegistry;

public class DefaultExtensionModelService
implements InternalExtensionModelService {
    private ExtensionModelDiscoverer extensionModelDiscoverer = new ExtensionModelDiscoverer();
    private MavenClient mavenClient;
    private MuleArtifactResourcesRegistry muleArtifactResourcesRegistry;

    public DefaultExtensionModelService(MavenClient mavenClient, MuleArtifactResourcesRegistry muleArtifactResourcesRegistry) {
        Objects.requireNonNull(mavenClient, "mavenClient cannot be null");
        Objects.requireNonNull(muleArtifactResourcesRegistry, "muleArtifactResourcesRegistry cannot be null");
        this.mavenClient = mavenClient;
        this.muleArtifactResourcesRegistry = muleArtifactResourcesRegistry;
    }

    @Override
    public List<ExtensionModel> loadMuleExtensionModels() {
        return Arrays.asList(MuleExtensionModelProvider.getExtensionModel(), MuleEeExtensionModelProvider.getExtensionModel());
    }

    private Optional<Pair<ExtensionModel, ArtifactClassLoader>> resolveExtensionModel(ArtifactPluginDescriptor artifactPluginDescriptor) throws IOException, MuleException {
        ToolingPluginClassLoaderBuilder builder = new ToolingPluginClassLoaderBuilder(this.muleArtifactResourcesRegistry.newTemporaryArtifactClassLoaderFactory(), this.muleArtifactResourcesRegistry.getPluginDependenciesResolver(), artifactPluginDescriptor, this.muleArtifactResourcesRegistry.getRegionPluginClassLoadersFactory());
        builder.setParentClassLoader(this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader());
        ArtifactClassLoader pluginClassLoader = builder.build();
        MuleExtensionModelLoaderManager extensionModelLoaderRepository = new MuleExtensionModelLoaderManager(this.muleArtifactResourcesRegistry.getContainerArtifactClassLoader());
        extensionModelLoaderRepository.start();
        Optional<ExtensionModel> extensionModel = this.getExtensionModel(artifactPluginDescriptor, pluginClassLoader, (ExtensionModelLoaderRepository)extensionModelLoaderRepository);
        if (!extensionModel.isPresent()) {
            pluginClassLoader.dispose();
            return Optional.empty();
        }
        return Optional.of(new Pair((Object)extensionModel.get(), (Object)pluginClassLoader));
    }

    private Optional<ExtensionModel> getExtensionModel(ArtifactPluginDescriptor artifactPluginDescriptor, ArtifactClassLoader pluginClassLoader, ExtensionModelLoaderRepository extensionModelLoaderRepository) {
        Set extensionModels = this.extensionModelDiscoverer.discoverExtensionModels(extensionModelLoaderRepository, (List)Lists.newArrayList((Object[])new Pair[]{new Pair((Object)artifactPluginDescriptor, (Object)pluginClassLoader)}));
        if (extensionModels.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(extensionModels.iterator().next());
    }

    @Override
    public Optional<Pair<ExtensionModel, ArtifactClassLoader>> loadPairArtifactClassLoaderAndExtensionModel(ArtifactDescriptor pluginDescriptor) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder();
        builder.setGroupId(pluginDescriptor.getGroupId()).setArtifactId(pluginDescriptor.getArtifactId()).setType(pluginDescriptor.getExtension()).setVersion(pluginDescriptor.getVersion()).setClassifier(pluginDescriptor.getClassifier()).build();
        return this.loadPairArtifactClassLoaderAndExtensionModel(new File(this.mavenClient.resolveBundleDescriptor(builder.build()).getBundleUri()));
    }

    @Override
    public Optional<Pair<ExtensionModel, ArtifactClassLoader>> loadPairArtifactClassLoaderAndExtensionModel(File file) {
        File tempFolder = Files.createTempDir();
        try {
            ArtifactPluginDescriptor artifactPluginDescriptor = this.muleArtifactResourcesRegistry.getArtifactPluginDescriptorLoader().load(file);
            Optional<Pair<ExtensionModel, ArtifactClassLoader>> optional = this.resolveExtensionModel(artifactPluginDescriptor);
            return optional;
        }
        catch (Exception e) {
            throw new ToolingException("Error while loading ExtensionModel for plugin: " + file.getAbsolutePath(), (Throwable)e);
        }
        finally {
            FileUtils.deleteQuietly((File)tempFolder);
        }
    }
}

