/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.util.Pair;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.descriptors.ArtifactDescriptor;
import org.mule.tooling.client.internal.InternalExtensionModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionModelServiceCache
implements Disposable {
    private static final String TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE = "tooling.client.ExtensionModelServiceCache.cache";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionModelServiceCache.class);
    private List<ExtensionModel> muleExtensionModels;
    private Cache<ArtifactDescriptor, Optional<Pair<ExtensionModel, ArtifactClassLoader>>> extensionModelsByArtifact = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).removalListener(notification -> ((Optional)notification.getValue()).ifPresent(pair -> this.closeClassLoader((ArtifactClassLoader)pair.getSecond()))).build();
    private Cache<File, Optional<Pair<ExtensionModel, ArtifactClassLoader>>> extensionModelsByFile = CacheBuilder.newBuilder().maximumSize((long)this.cacheMaximumSize().intValue()).removalListener(notification -> ((Optional)notification.getValue()).ifPresent(pair -> this.closeClassLoader((ArtifactClassLoader)pair.getSecond()))).build();

    private Integer cacheMaximumSize() {
        Integer cacheSize = Integer.valueOf(System.getProperty(TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE, "100"));
        Preconditions.checkArgument((cacheSize > 0 ? 1 : 0) != 0, (String)String.format("Wrong value %d provided in system property %s, the cache cannot be less that zero", cacheSize, TOOLING_CLIENT_EXTENSION_MODEL_SERVICE_CACHE_CACHE));
        return cacheSize;
    }

    public Optional<ExtensionModel> loadExtensionModel(ArtifactDescriptor pluginDescriptor, InternalExtensionModelService extensionModelService) {
        try {
            return ((Optional)this.extensionModelsByArtifact.get((Object)pluginDescriptor, () -> extensionModelService.loadPairArtifactClassLoaderAndExtensionModel(pluginDescriptor))).map(Pair::getFirst);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Optional<ExtensionModel> loadExtensionModel(File plugin, InternalExtensionModelService extensionModelService) {
        try {
            return ((Optional)this.extensionModelsByFile.get((Object)plugin, () -> extensionModelService.loadPairArtifactClassLoaderAndExtensionModel(plugin))).map(Pair::getFirst);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause());
            throw Throwables.propagate((Throwable)e);
        }
    }

    public List<ExtensionModel> loadMuleExtensionModels(InternalExtensionModelService extensionModelService) {
        if (this.muleExtensionModels == null) {
            this.muleExtensionModels = extensionModelService.loadMuleExtensionModels();
        }
        return this.muleExtensionModels;
    }

    private void closeClassLoader(ArtifactClassLoader artifactClassLoader) {
        block2: {
            try {
                artifactClassLoader.dispose();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.extensionModelsByFile.invalidateAll();
        this.extensionModelsByArtifact.invalidateAll();
    }
}

