/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.exception.ServiceUnavailableException;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataRequest;
import org.mule.tooling.client.internal.MetadataProvider;
import org.mule.tooling.client.internal.TimeoutMethodUtils;
import org.mule.tooling.client.internal.application.RemoteApplicationInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalMetadataProvider
implements MetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RemoteApplicationInvoker remoteApplicationInvoker;

    public InternalMetadataProvider(RemoteApplicationInvoker remoteApplicationInvoker) {
        Preconditions.checkNotNull((Object)remoteApplicationInvoker, (Object)"remoteApplicationInvoker cannot be null");
        this.remoteApplicationInvoker = remoteApplicationInvoker;
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getMetadataKeys(MetadataKeysRequest metadataKeysRequest) throws ServiceUnavailableException, ToolingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting metadata keys for: {} on application: {}", (Object)metadataKeysRequest, (Object)this.remoteApplicationInvoker);
        }
        Supplier<MetadataResult> metadataResultSupplier = () -> this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.getMetadataKeys(applicationId, metadataKeysRequest.getLocation().toString()));
        return TimeoutMethodUtils.withTimeout(metadataKeysRequest.getRequestTimeout(), metadataResultSupplier, Optional.of(ex -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Exception)ex)).onKeys()})), Optional.empty());
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(MetadataRequest metadataRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting operation metadata for: {} on application: {}", (Object)metadataRequest, (Object)this.remoteApplicationInvoker);
        }
        Supplier<MetadataResult> metadataResultSupplier = () -> this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.getOperationMetadata(applicationId, metadataRequest.getLocation().toString()));
        return TimeoutMethodUtils.withTimeout(metadataRequest.getRequestTimeout(), metadataResultSupplier, Optional.of(ex -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Exception)ex)).onComponent()})), Optional.empty());
    }

    @Override
    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(MetadataRequest metadataRequest) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting source metadata for: {} on application: {}", (Object)metadataRequest, (Object)this.remoteApplicationInvoker);
        }
        Supplier<MetadataResult> metadataResultSupplier = () -> this.remoteApplicationInvoker.evaluateWithRemoteApplication((applicationId, runtimeToolingService) -> runtimeToolingService.getSourceMetadata(applicationId, metadataRequest.getLocation().toString()));
        return TimeoutMethodUtils.withTimeout(metadataRequest.getRequestTimeout(), metadataResultSupplier, Optional.of(ex -> MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)((Exception)ex)).onComponent()})), Optional.empty());
    }
}

