/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.tooling.client.internal;

import static com.google.common.base.Preconditions.checkNotNull;
import static org.mule.runtime.api.value.ResolvingFailure.Builder.newFailure;
import static org.mule.runtime.api.value.ValueResult.resultFrom;
import static org.mule.tooling.client.internal.TimeoutMethodUtils.withTimeout;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.tooling.client.api.value.provider.ValueProviderRequest;
import org.mule.tooling.client.api.value.provider.ValueProviderService;
import org.mule.tooling.client.internal.application.Deployable;

import java.util.function.Supplier;

/**
 * Provides the capability of resolve the {@link Value values} for any Value Provider capable element in a Mule App.
 *
 * @since 1.0
 */
public class DefaultValueProviderService implements ValueProviderService {

  private Supplier<Deployable> deployableSupplier;

  public DefaultValueProviderService(Supplier<Deployable> deployableSupplier) {
    checkNotNull(deployableSupplier, "deployableSupplier cannot be null");
    this.deployableSupplier = deployableSupplier;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ValueResult getValues(ValueProviderRequest valueProviderRequest) {
    Deployable deployable = deployableSupplier.get();
    return withTimeout(valueProviderRequest.getRequestTimeout(),
                       () -> deployable.getRuntimeToolingService().getValues(deployable.getApplicationId(),
                                                                             valueProviderRequest.getLocation(),
                                                                             valueProviderRequest.getProviderName()),
                       throwable -> resultFrom(newFailure(throwable).build()));
  }
}
