/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.api.metadataprovider.DefaultApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.api.dsl.model.ResourceProvider;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.BaseApplicationModelFactory;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;

public class ApplicationModelFactoryFromExpandedFolder
extends BaseApplicationModelFactory {
    public ApplicationModelFactoryFromExpandedFolder(ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        super(componentBuildingDefinitionLoader);
    }

    @Override
    public Optional<org.mule.datasense.api.metadataprovider.ApplicationModel> createApplicationModel(URL applicationUrl, Set<ExtensionModel> extensionModels) {
        File file = FileUtils.toFile((URL)applicationUrl);
        return this.processAppLocation(file, extensionModels).map(applicationModel -> new DefaultApplicationModel(file.getAbsolutePath(), applicationModel, this.loadTypesData(file)));
    }

    private String loadTypesData(File appLocation) {
        try {
            return FileUtils.readFileToString((File)new File(new File(appLocation, "mule"), "application-types.xml"));
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Stream<String>> findConfigsFromApplicationDescriptor(File appLocation) throws IOException {
        File muleApplicationJson = new File(appLocation, ArtifactDescriptor.MULE_ARTIFACT_JSON_DESCRIPTOR_LOCATION);
        if (!muleApplicationJson.exists()) return Optional.of(Stream.of(ApplicationDescriptor.DEFAULT_CONFIGURATION_RESOURCE_LOCATION));
        try (FileInputStream stream = new FileInputStream(muleApplicationJson);){
            MuleApplicationModelJsonSerializer applicationDescriptor = new MuleApplicationModelJsonSerializer();
            MuleApplicationModel applicationModel = (MuleApplicationModel)applicationDescriptor.deserialize(IOUtils.toString((InputStream)stream));
            if (applicationModel.getConfigs().isEmpty()) return Optional.of(Stream.of(ApplicationDescriptor.DEFAULT_CONFIGURATION_RESOURCE_LOCATION));
            Optional<Stream<String>> optional = Optional.of(applicationModel.getConfigs().stream().map(configFileName -> Paths.get("mule", configFileName).toString()));
            return optional;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not read extension describer on plugin '%s'", muleApplicationJson.getAbsolutePath()), e);
        }
    }

    private Optional<ApplicationModel> readConfigs(Stream<String> configs, File appLocation, Set<ExtensionModel> extensionModels) {
        try {
            FolderResourceProvider externalResourceProvider = new FolderResourceProvider(appLocation);
            return Optional.of(this.loadApplicationModel(configs.map(configFileName -> {
                try {
                    File configFile = new File(appLocation, (String)configFileName);
                    return this.loadConfigFile((String)configFileName, new FileInputStream(configFile), extensionModels).get();
                }
                catch (FileNotFoundException e) {
                    throw new ToolingException((Throwable)e);
                }
            }).collect(Collectors.toList()), extensionModels, externalResourceProvider));
        }
        catch (Exception e) {
            throw new ToolingException((Throwable)e);
        }
    }

    private Optional<ApplicationModel> processAppLocation(File appLocation, Set<ExtensionModel> extensionModels) {
        try {
            return this.findConfigsFromApplicationDescriptor(appLocation).map(configs -> this.readConfigs((Stream<String>)configs, appLocation, extensionModels)).orElse(Optional.empty());
        }
        catch (IOException e) {
            throw new ToolingException((Throwable)e);
        }
    }

    private class FolderResourceProvider
    implements ResourceProvider {
        File appLocation;

        public FolderResourceProvider(File appLocation) {
            this.appLocation = appLocation;
        }

        public InputStream getResourceAsStream(String uri) {
            List<String> searchPaths = ApplicationModelFactoryFromExpandedFolder.this.getSearchPaths();
            try {
                Optional<File> result = searchPaths.stream().map(path -> new File(this.appLocation, path + "/" + uri)).filter(f -> f.exists()).findFirst();
                if (result.isPresent()) {
                    return new FileInputStream(result.get());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return null;
        }
    }
}

