/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.mule.datasense.api.metadataprovider.DefaultApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.persistence.MuleApplicationModelJsonSerializer;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.spring.api.dsl.model.ApplicationModel;
import org.mule.runtime.config.spring.api.dsl.model.ResourceProvider;
import org.mule.runtime.config.spring.api.dsl.processor.ConfigFile;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.BaseApplicationModelFactory;
import org.mule.tooling.client.internal.ComponentBuildingDefinitionLoader;

public class ApplicationModelFactoryFromUrl
extends BaseApplicationModelFactory {
    private static final String MULE_APPLICATION_JSON_PATH = ArtifactPluginDescriptor.MULE_ARTIFACT_FOLDER + "/" + "mule-artifact.json";
    private static final String APP_TYPES_PATH = "mule/application-types.xml";
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;

    public ApplicationModelFactoryFromUrl(ComponentBuildingDefinitionLoader componentBuildingDefinitionLoader) {
        super(componentBuildingDefinitionLoader);
    }

    @Override
    public Optional<org.mule.datasense.api.metadataprovider.ApplicationModel> createApplicationModel(URL applicationUrl, Set<ExtensionModel> extensionModels) {
        byte[] buffer = this.readToBuffer(applicationUrl);
        return this.processZip(buffer, extensionModels).map(applicationModel -> new DefaultApplicationModel(applicationUrl.getPath(), applicationModel, this.readTypesData(buffer)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readTypesData(byte[] buffer) {
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(buffer));){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                if (!entry.getName().equals(APP_TYPES_PATH)) continue;
                String string = IOUtils.toString((InputStream)zipInputStream);
                return string;
            }
            String string = null;
            return string;
        }
        catch (IOException e) {
            throw new ToolingException((Throwable)e);
        }
    }

    private byte[] readToBuffer(URL url) {
        byte[] byArray;
        BufferedInputStream inputStream = null;
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(5000);
            urlConnection.setReadTimeout(5000);
            inputStream = new BufferedInputStream(urlConnection.getInputStream());
            ByteArrayOutputStream bufferOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)bufferOutputStream);
            byArray = bufferOutputStream.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new ToolingException((Throwable)e);
            }
            catch (Throwable throwable) {
                org.mule.runtime.core.api.util.IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        org.mule.runtime.core.api.util.IOUtils.closeQuietly((Closeable)inputStream);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<Stream<String>> findConfigsFromDeployProperties(byte[] buffer) {
        Optional<Stream<String>> configsOptional = Optional.empty();
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(buffer));){
            MuleApplicationModel muleApplicationModel;
            ZipEntry entry;
            do {
                if ((entry = zipInputStream.getNextEntry()) == null) return Optional.of(configsOptional.orElse(Stream.of(ApplicationDescriptor.DEFAULT_CONFIGURATION_RESOURCE_LOCATION)));
            } while (!entry.getName().equals(MULE_APPLICATION_JSON_PATH) || (muleApplicationModel = (MuleApplicationModel)new MuleApplicationModelJsonSerializer().deserialize(IOUtils.toString((InputStream)zipInputStream))).getConfigs().isEmpty());
            Optional<Stream<String>> optional = Optional.of(muleApplicationModel.getConfigs().stream().map(configFileName -> Paths.get("mule", configFileName).toString()));
            return optional;
        }
        catch (IOException e) {
            throw new ToolingException((Throwable)e);
        }
    }

    private Optional<ApplicationModel> readConfigs(Stream<String> configs, byte[] buffer, Set<ExtensionModel> extensionModels) throws IOException {
        List configsList = configs.collect(Collectors.toList());
        Throwable throwable = null;
        try (ZipInputStream zipInputStream = new ZipInputStream(new ByteArrayInputStream(buffer));){
            ZipEntry entry;
            ArrayList<ConfigFile> configFiles = new ArrayList<ConfigFile>();
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String path = new File(entry.getName()).getPath();
                if (!configsList.contains(path)) continue;
                BoundedInputStream boundedInputStream = new BoundedInputStream((InputStream)zipInputStream);
                boundedInputStream.setPropagateClose(false);
                this.loadConfigFile(path, (InputStream)boundedInputStream, extensionModels).map(configLine -> configFiles.add((ConfigFile)configLine));
            }
            try {
                ZipResourceProvider externalResourceProvider = new ZipResourceProvider(buffer);
                Optional<ApplicationModel> optional = Optional.of(this.loadApplicationModel(configFiles, extensionModels, externalResourceProvider));
                return optional;
            }
            catch (Exception e) {
                try {
                    throw new ToolingException((Throwable)e);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private Optional<ApplicationModel> processZip(byte[] buffer, Set<ExtensionModel> extensionModels) {
        return this.findConfigsFromDeployProperties(buffer).map(configs -> {
            try {
                return this.readConfigs((Stream<String>)configs, buffer, extensionModels);
            }
            catch (IOException e) {
                throw new ToolingException((Throwable)e);
            }
        }).orElse(Optional.empty());
    }

    private class ZipResourceProvider
    implements ResourceProvider {
        byte[] buffer;

        public ZipResourceProvider(byte[] buffer) {
            this.buffer = buffer;
        }

        public InputStream getResourceAsStream(String uri) {
            ZipInputStream zipInputStream = null;
            List<String> searchPaths = ApplicationModelFactoryFromUrl.this.getSearchPaths();
            try {
                ZipEntry entry;
                zipInputStream = new ZipInputStream(new ByteArrayInputStream(this.buffer));
                while ((entry = zipInputStream.getNextEntry()) != null) {
                    ZipEntry finalEntry = entry;
                    if (!searchPaths.stream().anyMatch(path -> finalEntry.getName().equals(path + "/" + uri))) continue;
                    return zipInputStream;
                }
            }
            catch (IOException e) {
                IOUtils.closeQuietly(zipInputStream);
                throw new ToolingException((Throwable)e);
            }
            IOUtils.closeQuietly((InputStream)zipInputStream);
            return null;
        }
    }
}

