/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.tooling.client.api.metadata.MetadataKeysRequest;
import org.mule.tooling.client.api.metadata.MetadataRequest;
import org.mule.tooling.client.internal.MetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolingDataSenseMetadataProvider
implements DataSenseMetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private MetadataResult failure = null;
    private MetadataProvider metadataProvider;
    private int metadataTimeout;

    public ToolingDataSenseMetadataProvider(MetadataProvider metadataProvider, int metadataTimeout) {
        this.metadataProvider = metadataProvider;
        this.metadataTimeout = metadataTimeout;
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys(Location location) {
        MetadataKeysRequest metadataKeysRequest = new MetadataKeysRequest();
        metadataKeysRequest.setLocation(location);
        if (this.failure != null) {
            return this.failure;
        }
        try {
            return this.metadataProvider.getMetadataKeys(metadataKeysRequest);
        }
        catch (Exception e) {
            this.logger.debug("Error while resolving Metadata Keys for location: " + location, (Throwable)e);
            this.failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onKeys()});
            return this.failure;
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<OperationModel>> getOperationMetadata(Location location) {
        if (this.failure != null) {
            return this.failure;
        }
        try {
            return this.metadataProvider.getOperationMetadata(this.getMetadataRequest(location));
        }
        catch (Exception e) {
            this.logger.debug("Error while resolving Operation Metadata for location: " + location, (Throwable)e);
            this.failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
            return this.failure;
        }
    }

    public MetadataResult<ComponentMetadataDescriptor<SourceModel>> getSourceMetadata(Location location) {
        if (this.failure != null) {
            return this.failure;
        }
        try {
            return this.metadataProvider.getSourceMetadata(this.getMetadataRequest(location));
        }
        catch (Exception e) {
            this.logger.debug("Error while resolving Source Metadata for location: " + location, (Throwable)e);
            this.failure = MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onComponent()});
            return this.failure;
        }
    }

    private MetadataRequest getMetadataRequest(Location location) {
        MetadataRequest request = new MetadataRequest();
        request.setLocation(location);
        if (this.metadataTimeout > 0) {
            request.setRequestTimeout((long)this.metadataTimeout);
        }
        return request;
    }
}

